/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome;

import ru.autosome.Assistant;
import ru.autosome.MPWM;
import ru.autosome.PWM;
import ru.autosome.SMPWM;
import ru.autosome.Sequence;

public class SMSequence
extends Sequence {
    SMSequence(byte[] sequence) {
        super(sequence);
    }

    public static SMSequence sequenceFromString(String str) {
        int length = str.length();
        byte[] genome = new byte[length + 1];
        genome[0] = (byte)(20 + Assistant.charToByte(str.charAt(0)));
        for (int j = 0; j < length - 1; ++j) {
            genome[j + 1] = (byte)(5 * Assistant.charToByte(str.charAt(j)) + Assistant.charToByte(str.charAt(j + 1)));
        }
        genome[length] = (byte)(5 * Assistant.charToByte(str.charAt(length - 1)) + 4);
        return new SMSequence(genome);
    }

    @Override
    public void scan(PWM pwm, PWM revComp_pwm, double threshold) {
        if (SMPWM.lengthOfMPWMIsEven) {
            this.internalScan(pwm, revComp_pwm, threshold, 1, this.sequence.length - 2 * pwm.length() + 1, 0, 0, -1);
        } else {
            this.internalScan(pwm, revComp_pwm, threshold, 1, this.sequence.length - 2 * pwm.length() + 2, 0, -1, -1);
        }
    }

    @Override
    public void bestHit(PWM pwm, PWM revComp_pwm) {
        if (MPWM.lengthOfMPWMIsEven) {
            this.internalBestHit(pwm, revComp_pwm, 1, this.sequence.length - 2 * pwm.length() + 1, 0, 0, -1);
        } else {
            this.internalBestHit(pwm, revComp_pwm, 1, this.sequence.length - 2 * pwm.length() + 2, 0, -1, -1);
        }
    }
}

