/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome;

import ru.autosome.PWM;

public abstract class Sequence {
    byte[] sequence;

    Sequence(byte[] sequence) {
        this.sequence = sequence;
    }

    abstract void scan(PWM var1, PWM var2, double var3);

    abstract void bestHit(PWM var1, PWM var2);

    void internalScan(PWM pwm, PWM revComp_pwm, double threshold, int startIndex, int endIndex, int shiftForScoreInPWM, int shiftForScoreInRevCompPWM, int shiftForPrint) {
        StringBuilder b = new StringBuilder();
        for (int i = startIndex; i < endIndex; ++i) {
            double score2;
            double score1 = pwm.score(this, i + shiftForScoreInPWM);
            if (score1 >= threshold) {
                b.append(score1).append("\t").append(i + shiftForPrint).append("\t").append("+");
                System.out.println(b.toString());
                b.setLength(0);
            }
            if (!((score2 = revComp_pwm.score(this, i + shiftForScoreInRevCompPWM)) >= threshold)) continue;
            b.append(score2).append("\t").append(i + shiftForPrint).append("\t").append("-");
            System.out.println(b.toString());
            b.setLength(0);
        }
    }

    void internalBestHit(PWM pwm, PWM revComp_pwm, int startIndex, int endIndex, int shiftForScoreInPWM, int shiftForScoreInRevCompPWM, int shiftForPrint) {
        double best_score = Double.NEGATIVE_INFINITY;
        String DNAseq = "+";
        int index = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            double score1 = pwm.score(this, i + shiftForScoreInPWM);
            if (score1 >= best_score) {
                best_score = score1;
                DNAseq = "+";
                index = i;
            }
            if (!((score1 = revComp_pwm.score(this, i + shiftForScoreInRevCompPWM)) >= best_score)) continue;
            best_score = score1;
            DNAseq = "-";
            index = i;
        }
        StringBuilder b = new StringBuilder();
        b.append(best_score).append("\t").append(index + shiftForPrint).append("\t").append(DNAseq);
        System.out.println(b.toString());
    }
}

