package ru.autosome.assist;

public abstract class AShapeProvider {
  public abstract double[] shape(Integer motifLength);

  public static final AShapeProvider SingleBox = new AShapeProvider() {

    @Override
    public double[] shape(Integer motifLength) {
      double[] res = new double[motifLength];
      for (int i = 0; i < motifLength; i++) {
        double x = i - (motifLength - 1) / 2.0;
        double hack = Math.cos(Math.PI/10.5 * x);
        res[i] = hack * hack;
      }
      return res;
    }
  };

  public static final AShapeProvider DoubleBox  = new AShapeProvider() {

    @Override
    public double[] shape(Integer motifLength) {
      double[] res = new double[motifLength];
      for (int i = 0; i < motifLength; i++) {
        double x = i - (motifLength - 1) / 2.0;
        double hack = Math.sin(Math.PI/10.5 * x);
        res[i] = hack*hack;
      }
      return res;
    }
  };
  
}
