package ru.autosome.assist;

import org.apache.commons.math3.stat.descriptive.rank.Median;
import ru.autosome.ytilib.Sequence;

import java.util.ArrayList;
import java.util.List;

public abstract class ASequence {
  public double weight;

  protected byte[] direct; // sequence data
  protected byte[] revcomp; // sequence data

  public byte[] direct() {
    return direct;
  }
  public byte[] revcomp() {
    return direct;
  }
  public int length() {
    return direct.length;
  }

  protected double[] hdirect; // PWM hits
  protected double[] hrevcomp; // PWM hits

  public double bestHit(AMatrix wpcm) {
    double max_score = -Double.MAX_VALUE;
    for (int i = 0; i <= direct.length - wpcm.length; i++) {
      double current_score = wpcm.score(direct, i);
      double revcomp_score = wpcm.score(revcomp, i);
      max_score = Math.max(max_score, Math.max(current_score, revcomp_score));
    }
    return max_score;
  }

  public void bestHits(AMatrix wpcm, List<Integer> prihit, List<Integer> revhit) {

    prihit.clear();
    revhit.clear();

    double best_hit = wpcm.hits(direct, revcomp, hdirect, hrevcomp);

    for (int i = 0; i <= direct.length - wpcm.length; i++) {

      if (hdirect[i] >= best_hit) prihit.add(i);
      if (hrevcomp[i] >= best_hit) revhit.add(i);
    }

  }

  public void rebuild(AMatrix wpcm, List<Integer> prihits, List<Integer> revhits) {
    double total_weight = this.weight / (prihits.size() + revhits.size());

    for (Integer prihit : prihits) {
      for (int j = 0; j < wpcm.length; j++) {
        wpcm.matrix[this.direct[prihit + j]][j] += total_weight;
      }
    }
    for (Integer revhit : revhits) {
      for (int j = 0; j < wpcm.length; j++) {
        wpcm.matrix[this.revcomp[revhit + j]][j] += total_weight;
      }
    }
  }

  public abstract String word2str(byte[] seq, int offset, int length);

  public List<Occurrence> gatherOccurrences(AMatrix pm, double threshold) {
    List<Occurrence> result = new ArrayList<Occurrence>();

    for (int i = 0; i <= direct.length - pm.length; i++) {
      double direct_score = pm.score(direct, i);
      double revcomp_score = pm.score(revcomp, i);

      if (direct_score >= threshold) result.add(new Occurrence(word2str(direct,i,pm.length), i, Strand.DIRECT, direct_score));
      if (revcomp_score >= threshold) result.add(new Occurrence(word2str(revcomp,i,pm.length), revcomp.length - pm.length - i, Strand.REVCOMP, revcomp_score));
    }

    return result;
  }

  public boolean hasOccurrence(AMatrix pm, double threshold) {
    for (int i = 0; i <= direct.length - pm.length(); i++) {
      double direct_score = pm.score(direct, i);
      double revcomp_score = pm.score(revcomp, i);

      if (direct_score >= threshold) return true;
      if (revcomp_score >= threshold) return true;
    }
    return false;
  }

  public abstract ASequence copy();

  public byte[] getRevcomp() {
    return revcomp;
  }

  public byte[] getDirect() {
    return direct;
  }

  public static double medianLength(ASequence[] sequences) {
    Median m = new Median();
    double[] lengths = new double[sequences.length];
    for (int i = 0; i < sequences.length; i++) lengths[i] = sequences[i].length();
    return m.evaluate(lengths);
  }

  public static enum Strand {
    DIRECT, REVCOMP
  }
}
