package ru.autosome;

import ru.autosome.assist.Conductor;

public abstract class ChIPApp {
  protected Boolean verbose = false;

  public Conductor getConductor() {
    return conductor;
  }

  protected Conductor conductor = null;

  public ChIPApp(Conductor conductor) {
    this.conductor = conductor;
  }

  public abstract Object launch();

  public Object launchViaConductor() {
    return conductor.launch(this);
  }

  public abstract Object getResult();

  public static enum PreprocessMode {
    MASK, FILTER, DUMMY
  }

  public static enum SetType {
    SIMPLE, ORDERED, WEIGHTED, PEAK, MIDPOINT, RNA, UNKNOWN, RNAMIDPOINT
  }
}
