package ru.autosome.di.ytilib;

import ru.autosome.assist.AMatrix;
import ru.autosome.assist.Occurrence;

import java.util.ArrayList;
import java.util.List;

public class RNASequence extends Peak {

  public RNASequence(String sour) {
    super(sour);
    revcomp = null;
    prevcomp = null;
  }

  public RNASequence(String sour, double[] pdirect) {
    super(sour, pdirect);
    revcomp = null;
    prevcomp = null;
  }

  public RNASequence(String newseq, double[] newprof, double weight) {
    super(newseq, newprof, weight);
    revcomp = null;
    prevcomp = null;
  }

  public RNASequence(byte[] cdirect, byte[] crevcomp, double weight, double[] cpdirect, double[] cprevcomp) {
    super(cdirect, crevcomp, weight, cpdirect, cprevcomp);
    revcomp = null;
    prevcomp = null;
  }

  public RNASequence(byte[] cdirect, double weight, double[] cpdirect) {
    super(cdirect, null, weight, cpdirect, null);
  }

  @Override public void bestHits(AMatrix wpcm, List<Integer> prihit, List<Integer> revhit) {
    prihit.clear();
    revhit.clear();

    double best_hit = wpcm.hits(direct, hdirect, pdirect);

    for (int i = 0; i <= direct.length - wpcm.length(); i++) {
      if (hdirect[i] >= best_hit) prihit.add(i);
    }

  }

  public void soften(int length) {
    double[] newpd = new double[this.pdirect.length];
    for (int i = 0; i < this.pdirect.length; i++) {
      newpd[i] = max(pdirect, i-length + 1, i+length - 1);
    }
    this.pdirect = newpd;
  }

  @Override public Sequence copy() {

    byte[] cdirect = new byte[this.direct.length];
    java.lang.System.arraycopy(direct, 0, cdirect, 0, direct.length);

    double[] cpdirect = new double[this.pdirect.length];
    java.lang.System.arraycopy(pdirect, 0, cpdirect, 0, pdirect.length);

    return new RNASequence(cdirect, weight, cpdirect);
  }

  @Override public List<Occurrence> gatherOccurrences(AMatrix pm, double threshold) {
    List<Occurrence> result = new ArrayList<Occurrence>();

    for (int i = 0; i <= direct.length - pm.length(); i++) {
      double direct_score = pm.score(direct, i);

      if (direct_score >= threshold) result.add(new Occurrence(word2str(direct,i,pm.length()), i, Strand.DIRECT, direct_score));
    }

    return result;
  }

  @Override public boolean hasOccurrence(AMatrix pm, double threshold) {
    for (int i = 0; i <= direct.length - pm.length(); i++) {
      double direct_score = pm.score(direct, i);
      if (direct_score >= threshold) return true;
    }
    return false;
  }

}
