#!/usr/bin/ruby
$: << "#{File.dirname(File.expand_path(__FILE__))}/ytilib/"
require "ytilib.rb"

class PM
  def rcifn!
    rcdone = false
    g,c = @matrix['G'].sum, @matrix['C'].sum
    a,t = @matrix['A'].sum, @matrix['T'].sum
    if g+c > a+t
      (dummy = self.revcomp!, rcdone = true) if g <= c
    else
      (dummy = self.revcomp!, rcdone = true) if t <= a
    end
    return rcdone    
  end
end

def chipstep(motif_name, out_bismark, params)

  cmdline = "java -Xms268435456 -Xmx1073741824 -cp \"#{File.dirname(File.expand_path(__FILE__))}/chipmunk.jar\" ru.autosome.ChIPMunk #{params}"
  report "running chipmunk-engine: #{cmdline}"
  
  $ticket = File.name_wo_ext(out_bismark)
  
  result = `#{cmdline}`.split("\n").collect { |s| s.rstrip }
  File.open("#{$ticket}_chipmunk.log", "w") { |f|
    result.each { |r| f.puts(r) }
  }
  result_h = {}
  
  words = {}
  result.each { |line|
    key,value = line.split("|")
    next if key != "WORD"
    length = value.split[2].size
    words[length] = [] unless words[length]
    words[length] << value
  }
  
  result = result[result.index("OUTC|ru.autosome.ChIPMunk")..(result.size-1)]
  result.each { |v|
    key, value = v.split("|")
    if result_h[key]
      if result_h[key].is_a?(Array)
        result_h[key] << value
      else
        result_h[key] = [result_h[key], value]
      end
    else
      result_h[key] = value
    end
  }
  
  $diagnosis = result_h["DIAG"]
  words_count = result_h["N"].to_f
  
  a_counts = result_h['A'].split.collect { |c| c.to_f }
  c_counts = result_h['C'].split.collect { |c| c.to_f }
  g_counts = result_h['G'].split.collect { |c| c.to_f }
  t_counts = result_h['T'].split.collect { |c| c.to_f }
  pm = PM.new(a_counts.size, {'A' => a_counts, 'C' => c_counts, 'G' => g_counts, 'T' => t_counts }, words_count)
  
  pm.save(motif_name+".pcm")
  
  File.open("#{$ticket}_words.txt", "w") { |f|
    words[pm.size].each { |w| 
      f.puts(w)
    }
  } unless words.empty?
  
  bismark = Bismark.new
  bismark.root.add_element("motif", {"id" => "#{motif_name.to_id}.MTF", "name" => "#{motif_name}"})
  
  #revcomp = false
  #revcomp = pm.rcifn! unless $rna
  
  $ppm = pm.get_ppm
  $ppm.save(motif_name+".ppm")
  
  #infocod = $ppm.infocod
  #bismark.elements["//motif"].add_element("comment", {"name" => "discrete information content by position"}).add_text(infocod.inspect.to_s)
  #total_infocod = infocod.inject(0) { |ttl, icd| ttl += icd }
  #bismark.elements["//motif"].add_element("comment", {"name" => "discrete information content"}).add_text(total_infocod.to_s)
  
  $ppm.to_bismark(bismark.elements["//motif"])
  
  #pseudoc = Math.log(pm.words_count > 1 ? pm.words_count : 2)
  #($pwm = pm.get_pwm(nil, Randoom::DEF_PROBS, pseudoc)).to_bismark(bismark.elements["//motif"])
  
  a_weight = result_h['PWMA'].split.collect { |c| c.to_f }
  c_weight = result_h['PWMC'].split.collect { |c| c.to_f }
  g_weight = result_h['PWMG'].split.collect { |c| c.to_f }
  t_weight = result_h['PWMT'].split.collect { |c| c.to_f }
  $pwm = PM.new(a_weight.size, {'A' => a_weight, 'C' => c_weight, 'G' => g_weight, 'T' => t_weight }, nil)
  
  $pwm.to_bismark(bismark.elements["//motif"])
  
  File.open(out_bismark, "w") { |f| f << bismark.getXML }
  $pwm.save(motif_name+".pwm")
  
  File.open("#{motif_name}.dat","w") { |f|
    f.puts("TOTAL = #{result_h['TOTL']}")
    f.puts("SEQUENCES = #{result_h['SEQS']}")
    f.puts("WORDS = #{result_h['WRDS']}")
    f.puts("KDIC = #{result_h['KDIC']}")
    f.puts("THRESHOLD = #{result_h['THRE']}")
    f.puts("PVALUE = #{result_h['PVAL']}")
    f.puts("DIAGNOSIS = #{result_h['DIAG']}")
  }
  
  return words_count
end

report "run_chipmunk7.rb started, usage <motif_name> <ChIPMunk-engine-params>"
start __FILE__

exit(2) if ARGV.size < 2

motif_name = ARGV.shift
out_bismark = "#{motif_name}.xml"

$rna = ARGV.inject(false) { |sum,v| sum |= v[0,2].downcase == "r:" }

params = ARGV.inject("") { |pa, pr| pa += "#{pr} " }

sc = chipstep(motif_name, out_bismark, params)
system("ruby #{File.dirname(File.expand_path(__FILE__))}/pmflogo3.rb #{motif_name}.xml #{motif_name}.png #{sc}")

report $diagnosis
