/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.motifModels;

import java.util.ArrayList;
import ru.autosome.perfectosape.ArrayExtensions;
import ru.autosome.perfectosape.Sequence;
import ru.autosome.perfectosape.backgroundModels.BackgroundModel;
import ru.autosome.perfectosape.backgroundModels.WordwiseBackground;
import ru.autosome.perfectosape.calculations.ScoringModelDistributions.CountingPWM;
import ru.autosome.perfectosape.calculations.ScoringModelDistributions.ScoringModelDistibutions;
import ru.autosome.perfectosape.importers.PMParser;
import ru.autosome.perfectosape.motifModels.Discretable;
import ru.autosome.perfectosape.motifModels.PM;
import ru.autosome.perfectosape.motifModels.PositionWeightModel;
import ru.autosome.perfectosape.motifModels.ScoreDistribution;
import ru.autosome.perfectosape.motifModels.ScoreStatistics;
import ru.autosome.perfectosape.motifModels.ScoringModel;

public class PWM
extends PM
implements ScoringModel,
Discretable<PWM>,
ScoreStatistics<BackgroundModel>,
ScoreDistribution<BackgroundModel>,
PositionWeightModel {
    private double[] cache_best_suffices;
    private double[] cache_worst_suffices;

    public PWM(double[][] matrix, String name) throws IllegalArgumentException {
        super(matrix, name);
    }

    public static PWM fromParser(PMParser parser) {
        double[][] matrix = parser.matrix();
        String name = parser.name();
        return new PWM(matrix, name);
    }

    private static PWM new_from_text(ArrayList<String> input_lines) {
        return PWM.fromParser(new PMParser(input_lines));
    }

    double score(String word, BackgroundModel background) throws IllegalArgumentException {
        if ((word = word.toUpperCase()).length() != this.length()) {
            throw new IllegalArgumentException("word in PWM#score(word) should have the same length as matrix");
        }
        double sum = 0.0;
        for (int pos_index = 0; pos_index < this.length(); ++pos_index) {
            char letter = word.charAt(pos_index);
            Integer letter_index = indexByLetter.get(letter);
            if (letter_index != null) {
                sum += this.matrix[pos_index][letter_index];
                continue;
            }
            if (letter == 'N') {
                sum += background.mean_value(this.matrix[pos_index]);
                continue;
            }
            throw new IllegalArgumentException("word in PWM#score(#{word}) should have only ACGT or N letters, but have '" + letter + "' letter");
        }
        return sum;
    }

    public double score(Sequence word, BackgroundModel background) throws IllegalArgumentException {
        return this.score(word.sequence, background);
    }

    @Override
    public double score(Sequence word) throws IllegalArgumentException {
        return this.score(word, (BackgroundModel)new WordwiseBackground());
    }

    public double best_score() {
        return this.best_suffix(0);
    }

    public double worst_score() {
        return this.worst_suffix(0);
    }

    public double best_suffix(int i) {
        return this.best_suffices()[i];
    }

    double worst_suffix(int i) {
        return this.worst_suffices()[i];
    }

    double[] worst_suffices() {
        if (this.cache_worst_suffices == null) {
            double[] result = new double[this.length() + 1];
            result[this.length()] = 0.0;
            for (int pos_index = this.length() - 1; pos_index >= 0; --pos_index) {
                result[pos_index] = ArrayExtensions.min(this.matrix[pos_index]) + result[pos_index + 1];
            }
            this.cache_worst_suffices = result;
        }
        return this.cache_worst_suffices;
    }

    double[] best_suffices() {
        if (this.cache_best_suffices == null) {
            double[] result = new double[this.length() + 1];
            result[this.length()] = 0.0;
            for (int pos_index = this.length() - 1; pos_index >= 0; --pos_index) {
                result[pos_index] = ArrayExtensions.max(this.matrix[pos_index]) + result[pos_index + 1];
            }
            this.cache_best_suffices = result;
        }
        return this.cache_best_suffices;
    }

    @Override
    public PWM discrete(Double rate) {
        if (rate == null) {
            return this;
        }
        double[][] mat_result = new double[this.matrix.length][];
        for (int i = 0; i < this.matrix.length; ++i) {
            mat_result[i] = new double[4];
            for (int j = 0; j < 4; ++j) {
                mat_result[i][j] = Math.ceil(this.matrix[i][j] * rate);
            }
        }
        return new PWM(mat_result, this.name);
    }

    public PWM reverseComplement() {
        double[][] matrix_revcomp = (double[][])ArrayExtensions.reverse(this.matrix);
        for (int i = 0; i < matrix_revcomp.length; ++i) {
            matrix_revcomp[i] = ArrayExtensions.reverse(matrix_revcomp[i]);
        }
        return new PWM(matrix_revcomp, this.name);
    }

    public PWM leftAugment(int n) {
        int i;
        double[][] aligned_matrix = new double[this.length() + n][];
        for (i = 0; i < n; ++i) {
            aligned_matrix[i] = new double[]{0.0, 0.0, 0.0, 0.0};
        }
        for (i = 0; i < this.length(); ++i) {
            aligned_matrix[n + i] = this.matrix[i];
        }
        return new PWM(aligned_matrix, this.name);
    }

    public PWM rightAugment(int n) {
        int i;
        double[][] aligned_matrix = new double[this.length() + n][];
        for (i = 0; i < this.length(); ++i) {
            aligned_matrix[i] = this.matrix[i];
        }
        for (i = 0; i < n; ++i) {
            aligned_matrix[this.length() + i] = new double[]{0.0, 0.0, 0.0, 0.0};
        }
        return new PWM(aligned_matrix, this.name);
    }

    @Override
    public double score_mean(BackgroundModel background) {
        double result = 0.0;
        for (double[] pos : this.matrix) {
            result += background.mean_value(pos);
        }
        return result;
    }

    @Override
    public double score_variance(BackgroundModel background) {
        double variance = 0.0;
        for (double[] pos : this.matrix) {
            double mean_square = background.mean_square_value(pos);
            double mean = background.mean_value(pos);
            double squared_mean = mean * mean;
            variance += mean_square - squared_mean;
        }
        return variance;
    }

    @Override
    public ScoringModelDistibutions scoringModelDistibutions(BackgroundModel background, Integer maxHashSize) {
        return new CountingPWM(this, background, maxHashSize);
    }
}

