/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.cli;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import ru.autosome.perfectosape.BoundaryType;
import ru.autosome.perfectosape.backgroundModels.Background;
import ru.autosome.perfectosape.backgroundModels.BackgroundModel;
import ru.autosome.perfectosape.backgroundModels.WordwiseBackground;
import ru.autosome.perfectosape.calculations.ComparePWM;
import ru.autosome.perfectosape.calculations.HashOverflowException;
import ru.autosome.perfectosape.calculations.findThreshold.CanFindThreshold;
import ru.autosome.perfectosape.calculations.findThreshold.FindThresholdAPE;
import ru.autosome.perfectosape.cli.Helper;
import ru.autosome.perfectosape.importers.MotifCollectionImporter;
import ru.autosome.perfectosape.importers.PWMImporter;
import ru.autosome.perfectosape.motifModels.DataModel;
import ru.autosome.perfectosape.motifModels.PWM;

public class CollectDistanceMatrix {
    private static final String DOC = "Command-line format:\njava ru.autosome.perfectosape.cli.CollectDistanceMatrix <folder with PWMs> [options]\n\nOptions:\n  [--rough-discretization <discretization level>] or [-d]\n  [--precise-discretization <discretization level>]\n  [--precise [<level>]] minimal similarity to check on the second pass in precise mode, off by default, '--precise 0.01' if level is not set\n  [-p <P-value>]\n  [--boundary lower|upper] Upper boundary (default) means that the obtained P-value is greater than or equal to the requested P-value\n  [--pcm] - treat the input file as Position Count Matrix. PCM-to-PWM transformation to be done internally.\n  [--ppm] or [--pfm] - treat the input file as Position Frequency Matrix. PPM-to-PWM transformation to be done internally.\n  [--effective-count <count>] - effective samples set size for PPM-to-PWM conversion (default: 100). \n  [-b <background probabilities] ACGT - 4 numbers, comma-delimited(spaces not allowed), sum should be equal to 1, like 0.25,0.24,0.26,0.25\n  [--parallelize <num of threads> <thread number>] - run only one task per numOfThreads (those equal to thread number modulo numOfThreads)\n\nExamples:\n  java ru.autosome.perfectosape.cli.CollectDistanceMatrix ./motifs/ -d 10\n";
    Double roughDiscretization;
    Double preciseDiscretization;
    File pathToCollectionOfPWMs;
    BackgroundModel background;
    DataModel dataModel;
    Integer maxHashSize;
    Integer maxPairHashSize;
    double effectiveCount;
    BoundaryType pvalueBoundary;
    double pvalue;
    Double preciseRecalculationCutoff;
    int numOfThreads;
    int numThread;
    List<PWM> pwmCollection;

    private void initialize_defaults() {
        this.roughDiscretization = 1.0;
        this.preciseDiscretization = 10.0;
        this.background = new WordwiseBackground();
        this.maxHashSize = 10000000;
        this.maxPairHashSize = 10000;
        this.dataModel = DataModel.PWM;
        this.effectiveCount = 100.0;
        this.pvalue = 5.0E-4;
        this.pvalueBoundary = BoundaryType.UPPER;
        this.preciseRecalculationCutoff = null;
        this.numOfThreads = 1;
        this.numThread = 0;
        this.pathToCollectionOfPWMs = null;
        this.pwmCollection = null;
    }

    void extract_path_to_collection_of_pwms(List<String> argv) {
        try {
            this.pathToCollectionOfPWMs = new File(argv.remove(0));
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Specify PWM-collection folder", e);
        }
    }

    private void extract_option(List<String> argv) {
        String opt = argv.remove(0);
        if (opt.equals("-b")) {
            this.background = Background.fromString(argv.remove(0));
        } else if (opt.equals("-p")) {
            this.pvalue = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--max-hash-size")) {
            this.maxHashSize = Integer.valueOf(argv.remove(0));
        } else if (opt.equals("--max-2d-hash-size")) {
            this.maxPairHashSize = Integer.valueOf(argv.remove(0));
        } else if (opt.equals("--rough-discretization") || opt.equals("-d")) {
            this.roughDiscretization = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--precise-discretization")) {
            this.preciseDiscretization = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--pcm")) {
            this.dataModel = DataModel.PCM;
        } else if (opt.equals("--ppm") || opt.equals("--pfm")) {
            this.dataModel = DataModel.PPM;
        } else if (opt.equals("--effective-count")) {
            this.effectiveCount = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--boundary")) {
            this.pvalueBoundary = BoundaryType.valueOf(argv.remove(0).toUpperCase());
        } else if (opt.equals("--precise")) {
            this.preciseRecalculationCutoff = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--parallelize")) {
            this.numOfThreads = Integer.valueOf(argv.remove(0));
            this.numThread = Integer.valueOf(argv.remove(0));
        } else {
            throw new IllegalArgumentException("Unknown option '" + opt + "'");
        }
    }

    void setup_from_arglist(List<String> argv) throws FileNotFoundException {
        this.extract_path_to_collection_of_pwms(argv);
        while (argv.size() > 0) {
            this.extract_option(argv);
        }
        PWMImporter importer = new PWMImporter(this.background, this.dataModel, this.effectiveCount);
        this.pwmCollection = new MotifCollectionImporter<PWM>(importer).loadPWMCollection(this.pathToCollectionOfPWMs);
    }

    private CollectDistanceMatrix() {
        this.initialize_defaults();
    }

    private static CollectDistanceMatrix from_arglist(List<String> argv) throws FileNotFoundException {
        CollectDistanceMatrix result = new CollectDistanceMatrix();
        Helper.print_help_if_requested(argv, DOC);
        result.setup_from_arglist(argv);
        return result;
    }

    private static CollectDistanceMatrix from_arglist(String[] args) throws FileNotFoundException {
        ArrayList<String> argv = new ArrayList<String>();
        Collections.addAll(argv, args);
        return CollectDistanceMatrix.from_arglist(argv);
    }

    List<PWMWithThreshold> collectThreshold() throws HashOverflowException {
        ArrayList<PWMWithThreshold> result = new ArrayList<PWMWithThreshold>();
        for (PWM pwm : this.pwmCollection) {
            FindThresholdAPE<PWM, BackgroundModel> roughThresholdCalculator = new FindThresholdAPE<PWM, BackgroundModel>(pwm, this.background, this.roughDiscretization, this.maxHashSize);
            CanFindThreshold.ThresholdInfo roughThresholdInfo = roughThresholdCalculator.thresholdByPvalue(this.pvalue, this.pvalueBoundary);
            double roughThreshold = roughThresholdInfo.threshold;
            double roughCount = roughThresholdInfo.numberOfRecognizedWords(this.background, pwm.length());
            FindThresholdAPE<PWM, BackgroundModel> preciseThresholdCalculator = new FindThresholdAPE<PWM, BackgroundModel>(pwm, this.background, this.preciseDiscretization, this.maxHashSize);
            CanFindThreshold.ThresholdInfo preciseThresholdInfo = preciseThresholdCalculator.thresholdByPvalue(this.pvalue, this.pvalueBoundary);
            double preciseThreshold = preciseThresholdInfo.threshold;
            double preciseCount = preciseThresholdInfo.numberOfRecognizedWords(this.background, pwm.length());
            result.add(new PWMWithThreshold(pwm, roughThreshold, roughCount, preciseThreshold, preciseCount));
        }
        return result;
    }

    double calculateDistance(PWMWithThreshold first, PWMWithThreshold second) throws HashOverflowException {
        ComparePWM.ComparePWMCountsGiven calc = new ComparePWM.ComparePWMCountsGiven(first.pwm, second.pwm, this.background, this.background, this.roughDiscretization, this.maxPairHashSize);
        ComparePWM.SimilarityInfo info = calc.jaccard(first.roughThreshold, second.roughThreshold, first.roughCount, second.roughCount);
        if (this.preciseRecalculationCutoff != null && info.similarity() > this.preciseRecalculationCutoff) {
            calc = new ComparePWM.ComparePWMCountsGiven(first.pwm, second.pwm, this.background, this.background, this.preciseDiscretization, this.maxPairHashSize);
            info = calc.jaccard(first.preciseThreshold, second.preciseThreshold, first.preciseCount, second.preciseCount);
        }
        return info.distance();
    }

    public void process() throws HashOverflowException {
        int taskNum = 0;
        List<PWMWithThreshold> thresholds = this.collectThreshold();
        Collections.sort(thresholds, new Comparator<PWMWithThreshold>(){

            @Override
            public int compare(PWMWithThreshold o1, PWMWithThreshold o2) {
                return o1.pwm.name.compareTo(o2.pwm.name);
            }
        });
        System.out.print("Motif name\t");
        for (PWMWithThreshold second : thresholds) {
            System.out.print(second.pwm.name + "\t");
        }
        System.out.println();
        for (PWMWithThreshold first : thresholds) {
            System.out.print(first.pwm.name + "\t");
            for (PWMWithThreshold second : thresholds) {
                if (taskNum % this.numOfThreads == this.numThread % this.numOfThreads) {
                    int cmp = first.pwm.name.compareTo(second.pwm.name);
                    if (cmp == 0) {
                        System.out.print("0.0\t");
                    } else if (cmp < 0) {
                        System.out.print("x\t");
                    } else {
                        double distance = this.calculateDistance(first, second);
                        System.out.print(distance + "\t");
                    }
                } else {
                    System.out.print("x\t");
                }
                ++taskNum;
            }
            System.out.println();
            System.err.print(".");
        }
    }

    public static void main(String[] args) {
        try {
            CollectDistanceMatrix cli = CollectDistanceMatrix.from_arglist(args);
            cli.process();
        }
        catch (Exception err) {
            System.err.println("\n" + err.getMessage() + "\n--------------------------------------\n");
            err.printStackTrace();
            System.err.println("\n--------------------------------------\nUse --help option for help\n\nCommand-line format:\njava ru.autosome.perfectosape.cli.CollectDistanceMatrix <folder with PWMs> [options]\n\nOptions:\n  [--rough-discretization <discretization level>] or [-d]\n  [--precise-discretization <discretization level>]\n  [--precise [<level>]] minimal similarity to check on the second pass in precise mode, off by default, '--precise 0.01' if level is not set\n  [-p <P-value>]\n  [--boundary lower|upper] Upper boundary (default) means that the obtained P-value is greater than or equal to the requested P-value\n  [--pcm] - treat the input file as Position Count Matrix. PCM-to-PWM transformation to be done internally.\n  [--ppm] or [--pfm] - treat the input file as Position Frequency Matrix. PPM-to-PWM transformation to be done internally.\n  [--effective-count <count>] - effective samples set size for PPM-to-PWM conversion (default: 100). \n  [-b <background probabilities] ACGT - 4 numbers, comma-delimited(spaces not allowed), sum should be equal to 1, like 0.25,0.24,0.26,0.25\n  [--parallelize <num of threads> <thread number>] - run only one task per numOfThreads (those equal to thread number modulo numOfThreads)\n\nExamples:\n  java ru.autosome.perfectosape.cli.CollectDistanceMatrix ./motifs/ -d 10\n");
            System.exit(1);
        }
    }

    static class PWMWithThreshold {
        PWM pwm;
        double roughThreshold;
        double roughCount;
        double preciseThreshold;
        double preciseCount;

        PWMWithThreshold(PWM pwm, double roughThreshold, double roughCount, double preciseThreshold, double preciseCount) {
            this.pwm = pwm;
            this.roughThreshold = roughThreshold;
            this.roughCount = roughCount;
            this.preciseThreshold = preciseThreshold;
            this.preciseCount = preciseCount;
        }
    }
}

