/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.calculations.findThreshold;

import ru.autosome.perfectosape.MathExtensions;
import ru.autosome.perfectosape.backgroundModels.GeneralizedBackgroundModel;
import ru.autosome.perfectosape.calculations.findThreshold.CanFindThresholdApproximation;
import ru.autosome.perfectosape.motifModels.ScoreStatistics;

public class GaussianThresholdEstimator<ModelType extends ScoreStatistics<BackgroundType>, BackgroundType extends GeneralizedBackgroundModel>
implements CanFindThresholdApproximation {
    final ModelType motif;
    final BackgroundType dibackground;

    public GaussianThresholdEstimator(ModelType motif, BackgroundType dibackground) {
        this.motif = motif;
        this.dibackground = dibackground;
    }

    @Override
    public double thresholdByPvalue(double pvalue) {
        double sigma = Math.sqrt(this.motif.score_variance(this.dibackground));
        double n_ = MathExtensions.inverf(1.0 - 2.0 * pvalue) * Math.sqrt(2.0);
        return this.motif.score_mean(this.dibackground) + n_ * sigma;
    }
}

