/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.calculations;

import java.util.ArrayList;
import ru.autosome.perfectosape.Position;
import ru.autosome.perfectosape.Sequence;
import ru.autosome.perfectosape.calculations.EstimateAffinity;
import ru.autosome.perfectosape.calculations.HashOverflowException;
import ru.autosome.perfectosape.calculations.ScanSequence;
import ru.autosome.perfectosape.calculations.findPvalue.CanFindPvalue;
import ru.autosome.perfectosape.motifModels.ScoringModel;

public class EstimateAffinityMinPvalue
implements EstimateAffinity {
    ScoringModel pwm;
    Sequence sequence;
    CanFindPvalue pvalueCalculator;
    ArrayList<Position> positions_to_check;

    public EstimateAffinityMinPvalue(ScoringModel pwm, Sequence sequence, CanFindPvalue pvalueCalculator, ArrayList<Position> positions_to_check) {
        this.pwm = pwm;
        this.sequence = sequence;
        this.pvalueCalculator = pvalueCalculator;
        this.positions_to_check = positions_to_check;
    }

    EstimateAffinityMinPvalue(ScoringModel pwm, Sequence sequence, CanFindPvalue pvalueCalculator) {
        this(pwm, sequence, pvalueCalculator, sequence.subsequence_positions(pwm.length()));
    }

    ScanSequence scanSequence() {
        return new ScanSequence(this.sequence, this.pwm, this.positions_to_check);
    }

    @Override
    public double affinity() throws HashOverflowException {
        double score = this.scanSequence().best_score();
        return this.pvalueCalculator.pvalueByThreshold((double)score).pvalue;
    }

    public Position bestPosition() {
        return this.scanSequence().best_position();
    }
}

