/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.backgroundModels;

import java.util.StringTokenizer;
import ru.autosome.perfectosape.ArrayExtensions;
import ru.autosome.perfectosape.backgroundModels.BackgroundModel;
import ru.autosome.perfectosape.backgroundModels.WordwiseBackground;

public class Background
implements BackgroundModel {
    private double[] background;

    public Background(double[] background) {
        if (Math.abs(ArrayExtensions.sum(background) - 1.0) > 1.0E-4) {
            throw new IllegalArgumentException("Background probabilities should be 1.0 being summarized");
        }
        this.background = background;
    }

    public static BackgroundModel fromArray(double[] background) {
        if (background.length != 4) {
            throw new IllegalArgumentException("Background constructor accepts double array of length 4");
        }
        boolean wordwise = true;
        for (int i = 0; i < 4; ++i) {
            if (!(Math.abs(background[i] - 1.0) > 1.0E-4)) continue;
            wordwise = false;
        }
        if (wordwise) {
            return new WordwiseBackground();
        }
        return new Background(background);
    }

    @Override
    public double probability(int index) {
        return this.background[index];
    }

    @Override
    public double count(int index) {
        return this.background[index];
    }

    @Override
    public double volume() {
        return 1.0;
    }

    public static BackgroundModel fromString(String s) {
        double[] background = new double[4];
        StringTokenizer parser = new StringTokenizer(s);
        for (int i = 0; i < 4; ++i) {
            background[i] = Double.valueOf(parser.nextToken(","));
        }
        return Background.fromArray(background);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            if (i != 0) {
                builder.append(',');
            }
            builder.append(this.background[i]);
        }
        return builder.toString();
    }

    @Override
    public boolean is_wordwise() {
        return false;
    }

    @Override
    public double mean_value(double[] values) {
        double result = 0.0;
        for (int letter = 0; letter < 4; ++letter) {
            result += values[letter] * this.probability(letter);
        }
        return result;
    }

    @Override
    public double mean_square_value(double[] values) {
        double mean_square = 0.0;
        for (int letter = 0; letter < 4; ++letter) {
            mean_square += values[letter] * values[letter] * this.probability(letter);
        }
        return mean_square;
    }

    public boolean equals(Object other) {
        if (other instanceof BackgroundModel) {
            boolean result = true;
            for (int i = 0; i < 4; ++i) {
                result = result && this.count(i) == ((BackgroundModel)other).count(i);
            }
            return result;
        }
        return false;
    }

    public static BackgroundModel fromGCContent(double gcContent) {
        double p_at = (1.0 - gcContent) / 2.0;
        double p_cg = gcContent / 2.0;
        return new Background(new double[]{p_at, p_cg, p_cg, p_at});
    }
}

