/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.di;

import java.util.List;
import ru.autosome.ChIPApp;
import ru.autosome.assist.AMunkResult;
import ru.autosome.assist.ASequence;
import ru.autosome.assist.AShapeProvider;
import ru.autosome.assist.Conductor;
import ru.autosome.di.ChIPAct;
import ru.autosome.di.engine.SoptiStep;
import ru.autosome.di.ytilib.MunkResult;
import ru.autosome.di.ytilib.WPCM;

public class ChIPMunk
extends ChIPApp {
    private ChIPApp.PreprocessMode actMode = null;
    private List<MunkResult> actPreprocessingList = null;
    int minLength;
    int maxLength;
    Double zoopsFactor;
    boolean motifFound;
    Integer motifLength;
    int delta;
    double[] background = null;
    ChIPAct.Parameters actParameters;
    AShapeProvider shapeProvider = null;
    MunkResult result = null;
    String[] params;

    @Override
    public MunkResult getResult() {
        return this.result;
    }

    public static void main(String[] args) {
        ChIPMunk chipmunk = new ChIPMunk(args, Conductor.defaultConductor);
        chipmunk.launchViaConductor();
    }

    public ChIPMunk(ChIPAct.Parameters actParameters, Parameters munkParameters) {
        super(actParameters.getConductor());
        this.minLength = munkParameters.getStartLength();
        this.maxLength = munkParameters.getStopLength();
        this.conductor.setTotalTicks((Math.abs(this.maxLength - this.minLength) + 1) * 9);
        this.delta = 1;
        if (this.maxLength < this.minLength) {
            this.delta = -1;
            this.minLength = munkParameters.getStopLength();
            this.maxLength = munkParameters.getStartLength();
        }
        this.verbose = munkParameters.getVerbose();
        this.zoopsFactor = munkParameters.getZoopsFactor();
        this.actParameters = actParameters;
        this.shapeProvider = munkParameters.getShapeProvider();
        this.motifFound = false;
        this.motifLength = this.delta > 0 ? this.minLength : this.maxLength;
    }

    public ChIPMunk(String[] params, Conductor conductor, ChIPApp.PreprocessMode mode, List<MunkResult> preprocessingList) {
        this(params, conductor);
        this.actMode = mode;
        this.actPreprocessingList = preprocessingList;
    }

    public ChIPMunk(String[] args, Conductor conductor) {
        super(conductor);
        conductor.message("ru.autosome.di.ChIPMunk usage: <start_length> <stop_length> <verbose=(n)o|(y)es> <mode=(o)ops|zoops_factor=1.0|0.0> <ru.autosome.di.ChIPAct parameters>");
        if (args.length == 1) {
            this.verbose = true;
            this.minLength = 7;
            this.maxLength = 22;
            conductor.setTotalTicks((Math.abs(this.maxLength - this.minLength) + 1) * 9);
            this.zoopsFactor = 1.0;
            this.motifFound = false;
            this.motifLength = 7;
            this.delta = 1;
            this.params = new String[]{null, args[0], "200", "20", "1", "2"};
        } else if (args.length >= 5) {
            this.minLength = new Integer(args[0]);
            this.maxLength = new Integer(args[1]);
            conductor.setTotalTicks((Math.abs(this.maxLength - this.minLength) + 1) * 9);
            this.delta = 1;
            if (this.maxLength < this.minLength) {
                this.delta = -1;
                this.minLength = new Integer(args[1]);
                this.maxLength = new Integer(args[0]);
            }
            this.verbose = args[2].toUpperCase().charAt(0) == 'Y';
            boolean oops = args[3].toUpperCase().charAt(0) == 'O';
            this.zoopsFactor = null;
            if (!oops) {
                this.zoopsFactor = new Double(args[3]);
            }
            this.params = new String[args.length - 3];
            System.arraycopy(args, 4, this.params, 1, this.params.length - 1);
            this.motifFound = false;
            this.motifLength = this.delta > 0 ? this.minLength : this.maxLength;
        } else {
            throw new RuntimeException("not enough parameters");
        }
    }

    @Override
    public MunkResult launch() {
        AMunkResult newResult = null;
        AMunkResult result = null;
        while (this.motifLength <= this.maxLength && this.motifLength >= this.minLength && !this.motifFound) {
            boolean badNewMotif;
            ChIPAct step;
            this.conductor.message("trying motif length: " + this.motifLength);
            if (this.params != null) {
                this.params[0] = this.motifLength.toString();
                step = new ChIPAct(this.params, this.conductor, this.actMode, this.actPreprocessingList);
            } else {
                this.actParameters.setMotifLength(this.motifLength);
                if (this.shapeProvider != null) {
                    this.actParameters.setShape(this.shapeProvider.shape(this.motifLength));
                }
                step = new ChIPAct(this.actParameters);
            }
            step.launchViaConductor();
            if (step.getResult() == null) {
                this.conductor.message("no motif found, please check your input data and parameters");
                return null;
            }
            if (this.background == null) {
                this.background = step.background;
            }
            WPCM respcm = step.getBest();
            this.conductor.message("checking motif strength...");
            SoptiStep basestep = new SoptiStep(step.joinedSets, step.joinedSets.length, this.background, 2000);
            basestep.optimize(respcm);
            if (this.zoopsFactor == null) {
                WPCM reswoweights = new WPCM(this.motifLength, basestep.getPrimaryHits(), basestep.getRevcompHits(), step.joinedSets, true);
                badNewMotif = !ChIPMunk.checkMotif(respcm, this.background);
                badNewMotif = badNewMotif || !ChIPMunk.checkMotif(reswoweights, this.background);
                newResult = new MunkResult(basestep.extractWordList(new WPCM(respcm).toPWM(this.background)), respcm, this.background, step.joinedSets.length, step.joinedSets.length, ASequence.medianLength(step.joinedSets));
            } else {
                this.conductor.message("applying ZOOPS segmentation procedure...");
                newResult = basestep.zoops(this.zoopsFactor, this.conductor);
                boolean bl = badNewMotif = !ChIPMunk.checkMotif(((MunkResult)newResult).getWPCM(), this.background);
            }
            if (this.delta < 0) {
                boolean bl = this.motifFound = !badNewMotif;
                if (this.motifFound) {
                    this.conductor.message("motif strength check successfully passed, taking current motif");
                    result = newResult;
                }
            } else {
                this.motifFound = false;
                if (result != null && badNewMotif) {
                    this.conductor.message("motif strength check not passed, taking previously found motif");
                    this.motifLength = this.motifLength - 1;
                    this.motifFound = true;
                } else {
                    if (result == null && badNewMotif) {
                        this.conductor.message("detected weak starting motif");
                        break;
                    }
                    if (!badNewMotif) {
                        this.conductor.message("found strong motif, saving");
                        result = newResult;
                    }
                }
            }
            if (this.motifFound) continue;
            this.motifLength = this.motifLength + this.delta;
        }
        this.conductor.output("OUTC", "ru.autosome.di.ChIPMunk");
        if (result != null) {
            if (this.motifLength >= this.maxLength) {
                this.conductor.message("found motif of the maximum allowed length " + this.maxLength + "; please, check input parameters");
            }
            if (this.motifLength <= this.minLength) {
                this.conductor.message("found motif of the minimum allowed length " + this.minLength + "; please, check input parameters");
            }
            this.conductor.setStatus(Conductor.Status.SUCCESS);
            if (this.motifFound) {
                this.conductor.message("success; final motif length: " + this.motifLength);
            }
            result.printout(this.conductor, this.verbose);
            this.conductor.output("LENG", this.motifFound ? this.motifLength : -1);
            this.conductor.output("KDDC", ((MunkResult)result).getWPCM().kdidic(this.background));
            ChIPAct.prettyOutputWPCM(this.conductor, ((MunkResult)result).getWPCM().getMatrix());
            ChIPAct.prettyOutputPWM(this.conductor, ((MunkResult)result).getPWM().getMatrix());
            this.conductor.output("THRE", result.getThreshold());
            this.conductor.output("IUPA", new ru.autosome.ytilib.WPCM(((MunkResult)result).getWPCM()).consensus1());
            if (this.zoopsFactor != null) {
                this.conductor.message("estimating P-value...");
                this.conductor.output("PVAL", result.pvalue());
            }
            ChIPAct.prettyOutputBackground(this.conductor, this.background);
            result.setDiagnosis(this.motifFound ? "success; strong motif found within the given lengths interval" : "partial success; strong motif found on the border of the given lengths interval");
            this.conductor.output("DIAG", result.getDiagnosis());
        } else {
            this.conductor.setStatus(Conductor.Status.FAIL);
            this.conductor.message("only weak motifs found; please extend allowed lengths range");
            newResult.printout(this.conductor, this.verbose);
            this.conductor.output("LENG", -1);
            this.conductor.output("KDDC", ((MunkResult)newResult).getWPCM().kdidic(this.background));
            ChIPAct.prettyOutputWPCM(this.conductor, ((MunkResult)newResult).getWPCM().getMatrix());
            ChIPAct.prettyOutputPWM(this.conductor, ((MunkResult)newResult).getPWM().getMatrix());
            this.conductor.output("THRE", newResult.getThreshold());
            this.conductor.output("IUPA", new ru.autosome.ytilib.WPCM(((MunkResult)newResult).getWPCM()).consensus1());
            if (this.zoopsFactor != null) {
                this.conductor.message("estimating P-value...");
                this.conductor.output("PVAL", newResult.pvalue());
            }
            ChIPAct.prettyOutputBackground(this.conductor, this.background);
            newResult.setDiagnosis("fail; strong motif not found within the given lengths range");
            this.conductor.output("DIAG", newResult.getDiagnosis());
        }
        return result != null ? result : newResult;
    }

    private static boolean checkMotif(WPCM mocheck, double[] background) {
        if (mocheck == null) {
            return false;
        }
        double leftborder = mocheck.kdidic(background, 0);
        double rightborder = mocheck.kdidic(background, mocheck.length() - 1);
        double icdLow = mocheck.thresholdLC();
        return leftborder >= icdLow && rightborder >= icdLow;
    }

    public static class Parameters {
        private int startLength;
        private int stopLength;
        private boolean verbose;
        private Double zoopsFactor;
        private AShapeProvider shapeProvider;

        public Parameters() {
            this.verbose = true;
            this.zoopsFactor = 1.0;
        }

        public Parameters(int startLength, int stopLength, boolean verbose, Double zoopsFactor) {
            this.verbose = verbose;
            this.zoopsFactor = zoopsFactor;
            this.startLength = startLength;
            this.stopLength = stopLength;
        }

        public void setShapeProvider(AShapeProvider shapeProvider) {
            this.shapeProvider = shapeProvider;
        }

        public int getStartLength() {
            return this.startLength;
        }

        public int getStopLength() {
            return this.stopLength;
        }

        public boolean getVerbose() {
            return this.verbose;
        }

        public Double getZoopsFactor() {
            return this.zoopsFactor;
        }

        public void setStartLength(int startLength) {
            this.startLength = startLength;
        }

        public void setStopLength(int stopLength) {
            this.stopLength = stopLength;
        }

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        public void setZoopsFactor(Double zoopsFactor) {
            this.zoopsFactor = zoopsFactor;
        }

        public AShapeProvider getShapeProvider() {
            return this.shapeProvider;
        }
    }
}

