/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.di;

import java.util.ArrayList;
import java.util.List;
import ru.autosome.ChIPApp;
import ru.autosome.assist.Conductor;
import ru.autosome.assist.Occurrence;
import ru.autosome.di.ChIPAct;
import ru.autosome.di.ChIPMunk;
import ru.autosome.di.ytilib.MunkResult;
import ru.autosome.di.ytilib.Sequence;
import ru.autosome.di.ytilib.WPCM;

public class ChIPHorde
extends ChIPApp {
    private int totalSeqs;
    private List<MunkResult> results = new ArrayList<MunkResult>();
    private List<Integer[]> lengthRanges;
    private ChIPApp.PreprocessMode mode;
    private String[] params;
    private List<Sequence[]> sequenceSets;
    private ChIPAct.Parameters actParameters;
    private ChIPMunk.Parameters munkParameters;

    public static void main(String[] args) {
        ChIPHorde chiphorde = new ChIPHorde(args, Conductor.defaultConductor);
        chiphorde.launchViaConductor();
    }

    public ChIPHorde(List<Integer[]> lengthRanges, ChIPApp.PreprocessMode mode, ChIPAct.Parameters actParameters, ChIPMunk.Parameters munkParameters) {
        super(actParameters.getConductor());
        this.lengthRanges = lengthRanges;
        int sum = 0;
        for (Integer[] lengthRange : lengthRanges) {
            sum += Math.abs(lengthRange[0] - lengthRange[1]) + 1;
        }
        this.conductor.setTotalTicks(sum * 9);
        this.mode = mode;
        this.verbose = munkParameters.getVerbose();
        actParameters.setMotifLength(1);
        ChIPAct falseAct = new ChIPAct(actParameters);
        this.sequenceSets = falseAct.sequenceSets;
        this.totalSeqs = falseAct.joinedSets.length;
        this.actParameters = actParameters;
        actParameters.setPreprocessList(this.results);
        actParameters.setPreprocessMode(mode);
        this.munkParameters = munkParameters;
    }

    public ChIPHorde(String[] args, Conductor conductor) {
        super(conductor);
        conductor.message("ru.autosome.di.ChIPHorde engine usage: <start_length1:stop_length1,start_length2:stop_length2..start_lengthN:stop_lengthN> <mode=(m)ask|(f)ilter|(d)ummy> <verbose=(n)o|(p)artial|(y)es> <ru.autosome.di.ChIPMunk parameters>");
        if (args.length < 5) {
            throw new RuntimeException("not enough parameters");
        }
        if (args[3].startsWith("o")) {
            throw new RuntimeException("ChIPHorde cannot be used along with one-occurence-per-sequence (OOPS) mode");
        }
        this.params = new String[args.length];
        System.arraycopy(args, 2, this.params, 2, this.params.length - 2);
        char vchar = args[2].toUpperCase().charAt(0);
        this.verbose = vchar == 'Y' ? Boolean.valueOf(true) : (vchar == 'N' ? Boolean.valueOf(false) : null);
        this.params[2] = this.verbose != null && this.verbose != false ? "yes" : "no";
        String[] lengthDiaps = args[0].split(",");
        this.lengthRanges = new ArrayList<Integer[]>();
        int sum = 0;
        for (int i = 0; i < lengthDiaps.length; ++i) {
            int startLength = new Integer(lengthDiaps[i].split(":")[0]);
            int stopLength = new Integer(lengthDiaps[i].split(":")[1]);
            this.lengthRanges.add(new Integer[]{startLength, stopLength});
            sum += Math.abs(startLength - stopLength) + 1;
        }
        conductor.setTotalTicks(sum * 9);
        char modeChar = args[1].toUpperCase().charAt(0);
        ChIPApp.PreprocessMode preprocessMode = modeChar == 'F' ? ChIPApp.PreprocessMode.FILTER : (modeChar == 'M' ? ChIPApp.PreprocessMode.MASK : (this.mode = modeChar == 'D' ? ChIPApp.PreprocessMode.DUMMY : null));
        if (this.mode == null) {
            throw new RuntimeException("unknown preprocessing mode " + args[1]);
        }
        String[] newparams = new String[args.length - 3];
        System.arraycopy(args, 4, newparams, 1, args.length - 4);
        newparams[0] = "1";
        ChIPAct falseAct = new ChIPAct(newparams, conductor);
        this.sequenceSets = falseAct.sequenceSets;
        this.totalSeqs = falseAct.joinedSets.length;
    }

    @Override
    public List<MunkResult> getResult() {
        return this.results;
    }

    @Override
    public Object launch() {
        int i;
        if (this.verbose != null && !this.verbose.booleanValue()) {
            this.conductor.silence();
        }
        String message = null;
        int sumticks = 0;
        for (i = 0; i < this.lengthRanges.size(); ++i) {
            ChIPMunk chipmunk;
            int startLength = this.lengthRanges.get(i)[0];
            int stopLength = this.lengthRanges.get(i)[1];
            this.conductor.message("starting " + i + "-th iteration, " + this.mode.toString() + " mode");
            if (this.params != null) {
                this.params[0] = "" + startLength;
                this.params[1] = "" + stopLength;
                chipmunk = new ChIPMunk(this.params, this.conductor, this.mode, this.results);
            } else {
                this.munkParameters.setStartLength(startLength);
                this.munkParameters.setStopLength(stopLength);
                chipmunk = new ChIPMunk(this.actParameters, this.munkParameters);
            }
            MunkResult munkResult = (MunkResult)chipmunk.launchViaConductor();
            if (munkResult == null) {
                message = "got no result from the last stage, please check the program log";
                break;
            }
            WPCM motif = munkResult.getWPCM();
            this.conductor.updateTicks(sumticks += (Math.abs(startLength - stopLength) + 1) * 9);
            if (motif == null) {
                message = "empty motif came from the step " + i + ", unknown error";
                break;
            }
            this.results.add(munkResult);
        }
        this.conductor.verbose();
        this.conductor.output("OUTC", "ru.autosome.di.ChIPHorde");
        this.conductor.output("INFO", "found " + this.results.size() + " motifs, used " + this.totalSeqs + " sequences");
        for (i = 0; i < this.results.size(); ++i) {
            MunkResult result = this.results.get(i);
            this.conductor.output("MOTF", "motif # " + i);
            result.printout(this.conductor, this.verbose == null || this.verbose != false);
            this.conductor.output("LENG", result.getWPCM().length());
            this.conductor.output("KDDC", result.getWPCM().kdidic(this.results.get(i).getBackground()));
            ChIPAct.prettyOutputWPCM(this.conductor, result.getWPCM().getMatrix());
            this.conductor.output("THRE", result.getThreshold());
            this.conductor.output("IUPA", new ru.autosome.ytilib.WPCM(result.getWPCM()).consensus1());
            ChIPAct.prettyOutputPWM(this.conductor, result.getPWM().getMatrix());
            ChIPAct.prettyOutputBackground(this.conductor, result.getBackground());
            this.conductor.output("PVAL", result.pvalue());
            this.conductor.output("DIAG", result.getDiagnosis());
            if (this.verbose == null || !this.verbose.booleanValue()) continue;
            this.reportOccurrences(this.conductor, result.getPWM(), result.getThreshold());
        }
        this.conductor.output("DIAG", message != null ? "fail; " + message : "success; found a given number of motifs");
        this.conductor.setStatus(message != null ? Conductor.Status.FAIL : Conductor.Status.SUCCESS);
        return this.results;
    }

    public void reportOccurrences(Conductor conductor, WPCM pm, double threshold) {
        for (int i = 0; i < this.sequenceSets.size(); ++i) {
            ChIPHorde.reportOccurrences(conductor, pm, threshold, this.sequenceSets.get(i), new StringBuilder().append(i));
        }
    }

    private static void reportOccurrences(Conductor conductor, WPCM pm, double threshold, Sequence[] seqs, StringBuilder prefix) {
        for (int i = 0; i < seqs.length; ++i) {
            StringBuilder printout = new StringBuilder(prefix);
            printout.append(";").append(i).append(";");
            Sequence seq = seqs[i];
            List<Occurrence> occurrences = seq.gatherOccurrences(pm, threshold);
            for (Occurrence occurrence : occurrences) {
                printout.append(" ").append(occurrence);
            }
            if (occurrences.size() <= 0) continue;
            conductor.output("OCCS", printout);
        }
    }
}

