/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.ytilib;

import java.util.Arrays;
import ru.autosome.perfectosape.backgroundModels.Background;
import ru.autosome.perfectosape.backgroundModels.BackgroundModel;
import ru.autosome.perfectosape.calculations.HashOverflowException;
import ru.autosome.perfectosape.calculations.findPvalue.CanFindPvalue;
import ru.autosome.perfectosape.calculations.findPvalue.FindPvalueAPE;
import ru.autosome.perfectosape.motifModels.PWM;
import ru.autosome.ytilib.WPCM;

public class PerfectosPvalue {
    private final FindPvalueAPE<PWM, BackgroundModel> calculator;

    public PerfectosPvalue(WPCM pwm, double[] background) {
        Background backgroundModel = new Background(Arrays.copyOfRange(background, 0, 4));
        double[][] newMatrix = new double[pwm.length()][4];
        double[][] oldMatrix = pwm.getMatrix();
        for (int i = 0; i < pwm.length(); ++i) {
            for (int l = 0; l < 4; ++l) {
                newMatrix[i][l] = oldMatrix[l][i];
            }
        }
        this.calculator = new FindPvalueAPE<PWM, Background>(new PWM(newMatrix, null), backgroundModel, 10000.0, null);
    }

    public double PointPvalue(double threshold) {
        CanFindPvalue.PvalueInfo info = null;
        try {
            info = this.calculator.pvalueByThreshold(threshold);
        }
        catch (HashOverflowException e) {
            throw new RuntimeException("hash overflow during P-value evaluation");
        }
        return info.pvalue;
    }
}

