/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.motifModels;

import java.util.HashMap;
import ru.autosome.perfectosape.backgroundModels.AbstractBackgroundFactory;
import ru.autosome.perfectosape.backgroundModels.DiBackgroundFactory;
import ru.autosome.perfectosape.backgroundModels.DiBackgroundModel;
import ru.autosome.perfectosape.motifModels.BackgroundCompatible;
import ru.autosome.perfectosape.motifModels.MatrixModel;
import ru.autosome.perfectosape.motifModels.Named;

public class DiPM
implements Named,
MatrixModel,
BackgroundCompatible<DiBackgroundModel> {
    public static final int ALPHABET_SIZE = 16;
    public final double[][] matrix;
    public String name;
    static HashMap<String, Integer> indexByLetter = new HashMap();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public DiPM(double[][] matrix, String name) throws IllegalArgumentException {
        for (double[] pos : matrix) {
            if (pos.length == 16) continue;
            throw new IllegalArgumentException("Matrix must have 16 elements in each position");
        }
        this.matrix = matrix;
        this.name = name;
    }

    public int length() {
        return this.matrix.length + 1;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.name).append("\n");
        for (double[] pos : this.matrix) {
            for (int letter_index = 0; letter_index < 16; ++letter_index) {
                if (letter_index != 0) {
                    result.append("\t");
                }
                result.append(pos[letter_index]);
            }
            result.append("\n");
        }
        return result.toString();
    }

    @Override
    public double[][] getMatrix() {
        return this.matrix;
    }

    @Override
    public int alphabetSize() {
        return 16;
    }

    @Override
    public AbstractBackgroundFactory compatibleBackground() {
        return new DiBackgroundFactory();
    }

    static {
        indexByLetter.put("AA", 0);
        indexByLetter.put("AC", 1);
        indexByLetter.put("AG", 2);
        indexByLetter.put("AT", 3);
        indexByLetter.put("CA", 4);
        indexByLetter.put("CC", 5);
        indexByLetter.put("CG", 6);
        indexByLetter.put("CT", 7);
        indexByLetter.put("GA", 8);
        indexByLetter.put("GC", 9);
        indexByLetter.put("GG", 10);
        indexByLetter.put("GT", 11);
        indexByLetter.put("TA", 12);
        indexByLetter.put("TC", 13);
        indexByLetter.put("TG", 14);
        indexByLetter.put("TT", 15);
    }
}

