/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.cli;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.autosome.perfectosape.backgroundModels.DiBackground;
import ru.autosome.perfectosape.backgroundModels.DiBackgroundModel;
import ru.autosome.perfectosape.backgroundModels.DiWordwiseBackground;
import ru.autosome.perfectosape.backgroundModels.GeneralizedBackgroundModel;
import ru.autosome.perfectosape.calculations.findPvalue.FindPvalueAPE;
import ru.autosome.perfectosape.calculations.findPvalue.FindPvalueBsearchBuilder;
import ru.autosome.perfectosape.cli.Helper;
import ru.autosome.perfectosape.cli.MultiSNPScanGeneralized;
import ru.autosome.perfectosape.importers.DiPWMImporter;
import ru.autosome.perfectosape.importers.MotifCollectionImporter;
import ru.autosome.perfectosape.motifModels.DiPWM;

public class DiPWMMultiSNPScan
extends MultiSNPScanGeneralized<DiBackgroundModel> {
    @Override
    protected String DOC_run_string() {
        return "java ru.autosome.perfectosape.cli.DiPWMMultiSNPScan";
    }

    @Override
    protected String DOC_background_option() {
        return "ACGT - 16 numbers, comma-delimited(spaces not allowed), sum should be equal to 1, like 0.2,0.3,0.3,0.2,0.2,0.3,0.3,0.2,0.2,0.3,0.3,0.2,0.2,0.3,0.3,0.2";
    }

    private DiPWMMultiSNPScan() {
    }

    @Override
    protected void extract_background(String str) {
        this.background = DiBackground.fromString(str);
    }

    @Override
    protected void initialize_default_background() {
        this.background = new DiWordwiseBackground();
    }

    @Override
    protected void load_collection_of_pwms() throws FileNotFoundException {
        DiPWMImporter pwmImporter = new DiPWMImporter((DiBackgroundModel)this.background, this.dataModel, this.effectiveCount);
        MotifCollectionImporter<DiPWM> importer = new MotifCollectionImporter<DiPWM>(pwmImporter);
        List<DiPWM> pwmList = importer.loadPWMCollection(this.path_to_collection_of_pwms);
        this.pwmCollection = new ArrayList();
        for (DiPWM motif : pwmList) {
            FindPvalueAPE<DiPWM, GeneralizedBackgroundModel> pvalueCalculator = this.thresholds_folder == null ? new FindPvalueAPE<DiPWM, GeneralizedBackgroundModel>(motif, this.background, this.discretization, this.max_hash_size) : new FindPvalueBsearchBuilder(this.thresholds_folder).pvalueCalculator(motif);
            this.pwmCollection.add(new MultiSNPScanGeneralized.ThresholdEvaluator(motif, pvalueCalculator, motif.getName()));
        }
    }

    protected static MultiSNPScanGeneralized from_arglist(ArrayList<String> argv) throws FileNotFoundException {
        DiPWMMultiSNPScan result = new DiPWMMultiSNPScan();
        Helper.print_help_if_requested(argv, result.documentString());
        result.setup_from_arglist(argv);
        return result;
    }

    protected static MultiSNPScanGeneralized from_arglist(String[] args) throws FileNotFoundException {
        ArrayList<String> argv = new ArrayList<String>();
        Collections.addAll(argv, args);
        return DiPWMMultiSNPScan.from_arglist(argv);
    }

    public static void main(String[] args) {
        try {
            MultiSNPScanGeneralized calculation = DiPWMMultiSNPScan.from_arglist(args);
            calculation.process();
        }
        catch (Exception err) {
            System.err.println("\n" + err.getMessage() + "\n--------------------------------------\n");
            err.printStackTrace();
            System.err.println("\n--------------------------------------\nUse --help option for help\n\n" + new DiPWMMultiSNPScan().documentString());
            System.exit(1);
        }
    }
}

