/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.calculations;

import java.util.ArrayList;
import java.util.List;
import ru.autosome.perfectosape.BoundaryType;
import ru.autosome.perfectosape.PWMAligned;
import ru.autosome.perfectosape.backgroundModels.BackgroundModel;
import ru.autosome.perfectosape.calculations.ComparePWM;
import ru.autosome.perfectosape.calculations.HashOverflowException;
import ru.autosome.perfectosape.calculations.findPvalue.CanFindPvalue;
import ru.autosome.perfectosape.calculations.findPvalue.FindPvalueAPE;
import ru.autosome.perfectosape.calculations.findThreshold.CanFindThreshold;
import ru.autosome.perfectosape.calculations.findThreshold.FindThresholdAPE;
import ru.autosome.perfectosape.motifModels.PWM;

public class ScanCollection {
    List<ThresholdEvaluator> thresholdEvaluators;
    public final PWM queryPWM;
    public double pvalue;
    public Double queryPredefinedThreshold;
    public Double roughDiscretization;
    public Double preciseDiscretization;
    public BackgroundModel queryBackground;
    public BackgroundModel collectionBackground;
    public BoundaryType pvalueBoundaryType;
    public Integer maxHashSize;
    public Integer maxPairHashSize;
    public Double similarityCutoff;
    public Double preciseRecalculationCutoff;

    public ScanCollection(List<ThresholdEvaluator> thresholdEvaluators, PWM queryPWM) {
        this.thresholdEvaluators = thresholdEvaluators;
        this.queryPWM = queryPWM;
    }

    public List<SimilarityInfo> similarityInfos() throws HashOverflowException {
        ArrayList<SimilarityInfo> result = new ArrayList<SimilarityInfo>(this.thresholdEvaluators.size());
        FindPvalueAPE<PWM, BackgroundModel> roughQueryPvalueEvaluator = new FindPvalueAPE<PWM, BackgroundModel>(this.queryPWM, this.queryBackground, this.roughDiscretization, this.maxHashSize);
        FindPvalueAPE<PWM, BackgroundModel> preciseQueryPvalueEvaluator = new FindPvalueAPE<PWM, BackgroundModel>(this.queryPWM, this.queryBackground, this.preciseDiscretization, this.maxHashSize);
        double roughQueryThreshold = this.queryThreshold(this.roughDiscretization);
        double preciseQueryThreshold = this.queryThreshold(this.preciseDiscretization);
        for (ThresholdEvaluator knownMotifEvaluator : this.thresholdEvaluators) {
            boolean precise = false;
            ComparePWM roughCalculation = new ComparePWM(this.queryPWM, knownMotifEvaluator.pwm, this.queryBackground, this.collectionBackground, roughQueryPvalueEvaluator, knownMotifEvaluator.roughPvalueCalculator, this.roughDiscretization, this.maxPairHashSize);
            Double roughCollectionThreshold = knownMotifEvaluator.roughThresholdCalculator.thresholdByPvalue((double)this.pvalue, (BoundaryType)this.pvalueBoundaryType).threshold;
            ComparePWM.SimilarityInfo info = roughCalculation.jaccard(roughQueryThreshold, roughCollectionThreshold);
            if (this.preciseRecalculationCutoff != null && info.similarity() >= this.preciseRecalculationCutoff) {
                ComparePWM preciseCalculation = new ComparePWM(this.queryPWM, knownMotifEvaluator.pwm, this.queryBackground, this.collectionBackground, preciseQueryPvalueEvaluator, knownMotifEvaluator.precisePvalueCalculator, this.preciseDiscretization, this.maxPairHashSize);
                Double preciseCollectionThreshold = knownMotifEvaluator.preciseThresholdCalculator.thresholdByPvalue((double)this.pvalue, (BoundaryType)this.pvalueBoundaryType).threshold;
                info = preciseCalculation.jaccard(preciseQueryThreshold, preciseCollectionThreshold);
                precise = true;
            }
            if (this.similarityCutoff != null && !(info.similarity() >= this.similarityCutoff)) continue;
            result.add(new SimilarityInfo(knownMotifEvaluator.pwm, info, precise));
        }
        return result;
    }

    double queryThreshold(Double discretization) throws HashOverflowException {
        if (this.queryPredefinedThreshold != null) {
            return this.queryPredefinedThreshold;
        }
        FindThresholdAPE<PWM, BackgroundModel> pvalue_calculator = new FindThresholdAPE<PWM, BackgroundModel>(this.queryPWM, this.queryBackground, discretization, this.maxHashSize);
        return pvalue_calculator.thresholdByPvalue((double)this.pvalue, (BoundaryType)this.pvalueBoundaryType).threshold;
    }

    public static class ThresholdEvaluator {
        public PWM pwm;
        public CanFindThreshold roughThresholdCalculator;
        public CanFindThreshold preciseThresholdCalculator;
        public CanFindPvalue roughPvalueCalculator;
        public CanFindPvalue precisePvalueCalculator;

        public ThresholdEvaluator(PWM pwm, CanFindThreshold roughThresholdCalculator, CanFindThreshold preciseThresholdCalculator, CanFindPvalue roughPvalueCalculator, CanFindPvalue precisePvalueCalculator) {
            this.pwm = pwm;
            this.roughThresholdCalculator = roughThresholdCalculator;
            this.preciseThresholdCalculator = preciseThresholdCalculator;
            this.roughPvalueCalculator = roughPvalueCalculator;
            this.precisePvalueCalculator = precisePvalueCalculator;
        }
    }

    public static class SimilarityInfo
    extends ComparePWM.SimilarityInfo {
        public PWM collectionPWM;
        public boolean precise;

        public SimilarityInfo(PWM collectionPWM, PWMAligned alignment, double recognizedByBoth, double recognizedByFirst, double recognizedBySecond, boolean precise) {
            super(alignment, recognizedByBoth, recognizedByFirst, recognizedBySecond);
            this.collectionPWM = collectionPWM;
            this.precise = precise;
        }

        public SimilarityInfo(PWM collectionPWM, ComparePWM.SimilarityInfo similarityInfo, boolean precise) {
            super(similarityInfo.alignment, similarityInfo.recognizedByBoth, similarityInfo.recognizedByFirst, similarityInfo.recognizedBySecond);
            this.collectionPWM = collectionPWM;
            this.precise = precise;
        }

        public String name() {
            return this.collectionPWM.name;
        }
    }
}

