/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.autosome.perfectosape.BoundaryType;
import ru.autosome.perfectosape.api.Task;
import ru.autosome.perfectosape.backgroundModels.BackgroundModel;
import ru.autosome.perfectosape.calculations.PrecalculateThresholdList;
import ru.autosome.perfectosape.calculations.findPvalue.CanFindPvalue;
import ru.autosome.perfectosape.calculations.findPvalue.FindPvalueBsearch;
import ru.autosome.perfectosape.motifModels.PWM;

public class PrecalculateThresholdLists
extends Task<Map<PWM, CanFindPvalue>> {
    Parameters parameters;

    public PrecalculateThresholdLists(Parameters parameters) {
        this.parameters = parameters;
    }

    @Override
    public Integer getTotalTicks() {
        return this.parameters.pwmCollection.size();
    }

    public Map<PWM, CanFindPvalue> call() {
        HashMap<PWM, CanFindPvalue> results;
        this.setStatus(Task.Status.RUNNING);
        try {
            results = new HashMap<PWM, CanFindPvalue>();
            for (PWM pwm : this.parameters.pwmCollection) {
                if (this.interrupted()) {
                    return results;
                }
                results.put(pwm, new FindPvalueBsearch(this.calculator().bsearch_list_for_pwm(pwm)));
                this.tick();
            }
        }
        catch (Exception err) {
            this.setStatus(Task.Status.FAIL);
            return null;
        }
        this.setStatus(Task.Status.SUCCESS);
        return results;
    }

    PrecalculateThresholdList calculator() {
        return new PrecalculateThresholdList(this.parameters.pvalues, this.parameters.discretization, this.parameters.background, this.parameters.pvalue_boundary, this.parameters.max_hash_size);
    }

    public static class Parameters {
        public double discretization;
        public BackgroundModel background;
        public BoundaryType pvalue_boundary;
        public Integer max_hash_size;
        public double[] pvalues;
        public List<PWM> pwmCollection;

        public Parameters() {
        }

        public Parameters(List<PWM> pwmCollection, double[] pvalues, double discretization, BackgroundModel background, BoundaryType pvalue_boundary, Integer max_hash_size) {
            this.pwmCollection = pwmCollection;
            this.pvalues = pvalues;
            this.discretization = discretization;
            this.background = background;
            this.pvalue_boundary = pvalue_boundary;
            this.max_hash_size = max_hash_size;
        }
    }
}

