/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.motifModels;

import gnu.trove.impl.unmodifiable.TUnmodifiableCharIntMap;
import gnu.trove.map.TCharIntMap;
import gnu.trove.map.hash.TCharIntHashMap;
import ru.autosome.perfectosape.backgroundModels.BackgroundFactory;
import ru.autosome.perfectosape.backgroundModels.BackgroundModel;
import ru.autosome.perfectosape.motifModels.BackgroundCompatible;
import ru.autosome.perfectosape.motifModels.MatrixModel;
import ru.autosome.perfectosape.motifModels.Named;

public class PM
implements Named,
MatrixModel,
BackgroundCompatible<BackgroundModel> {
    public static final int ALPHABET_SIZE = 4;
    public final double[][] matrix;
    public String name;
    protected static final TCharIntMap indexByLetter = new TUnmodifiableCharIntMap(new TCharIntHashMap(new char[]{'A', 'C', 'G', 'T'}, new int[]{0, 1, 2, 3}));

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public double[][] getMatrix() {
        return this.matrix;
    }

    @Override
    public int alphabetSize() {
        return 4;
    }

    public PM(double[][] matrix, String name) throws IllegalArgumentException {
        for (double[] pos : matrix) {
            if (pos.length == 4) continue;
            throw new IllegalArgumentException("Matrix must have 4 elements in each position");
        }
        this.matrix = matrix;
        this.name = name;
    }

    public int length() {
        return this.matrix.length;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.name).append("\n");
        for (double[] pos : this.matrix) {
            for (int letter_index = 0; letter_index < 4; ++letter_index) {
                if (letter_index != 0) {
                    result.append("\t");
                }
                result.append(pos[letter_index]);
            }
            result.append("\n");
        }
        return result.toString();
    }

    public BackgroundFactory compatibleBackground() {
        return new BackgroundFactory();
    }
}

