/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.importers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import ru.autosome.perfectosape.importers.BufferedPushbackReader;
import ru.autosome.perfectosape.importers.PMParser;
import ru.autosome.perfectosape.motifModels.Named;
import ru.autosome.perfectosape.motifModels.ScoringModel;

public abstract class MotifImporter<ModelType extends Named & ScoringModel> {
    public abstract ModelType transformToPWM(double[][] var1, String var2);

    public List<ModelType> loadPWMsFromFile(File pathToPWMs) throws FileNotFoundException {
        ArrayList<ModelType> pwms = new ArrayList<ModelType>();
        BufferedPushbackReader reader = new BufferedPushbackReader(new FileInputStream(pathToPWMs));
        boolean canExtract = true;
        while (canExtract) {
            PMParser parser = PMParser.loadFromStream(reader);
            boolean bl = canExtract = canExtract && parser != null;
            if (parser == null) {
                canExtract = false;
                continue;
            }
            ModelType pwm = this.transformToPWM(parser.matrix(), parser.name());
            pwms.add(pwm);
        }
        return pwms;
    }

    public ModelType loadPWMFromParser(PMParser parser) {
        ModelType pwm = this.transformToPWM(parser.matrix(), parser.name());
        return pwm;
    }

    public List<ModelType> loadPWMsFromFolder(File pathToPWMs) {
        ArrayList<ModelType> result = new ArrayList<ModelType>();
        File[] files = pathToPWMs.listFiles();
        if (files == null) {
            return result;
        }
        for (File file : files) {
            result.add(this.loadPWMFromFile(file));
        }
        return result;
    }

    public ModelType loadPWMFromFile(File file) {
        PMParser parser = PMParser.from_file(file);
        ModelType pwm = this.transformToPWM(parser.matrix(), parser.name());
        if (pwm.getName() == null || pwm.getName().isEmpty()) {
            pwm.setName(file.getName().replaceAll("\\.[^.]+$", ""));
        }
        return pwm;
    }
}

