/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.formatters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.autosome.perfectosape.StringExtensions;
import ru.autosome.perfectosape.backgroundModels.GeneralizedBackgroundModel;
import ru.autosome.perfectosape.formatters.ResultInfo;

public class OutputInformation {
    private List<String> table_parameter_descriptions;
    private List<String> parameter_descriptions;
    private List<String> parameter_value_infos;
    private List<String> resulting_value_descriptions;
    private List<String> resulting_value_infos;
    private List<String> table_headers;
    private List<String> table_columns;
    private Map<String, Callback> table_column_callbacks;
    public List<? extends ResultInfo> data;

    private void initialize() {
        this.table_parameter_descriptions = new ArrayList<String>();
        this.parameter_descriptions = new ArrayList<String>();
        this.parameter_value_infos = new ArrayList<String>();
        this.resulting_value_descriptions = new ArrayList<String>();
        this.resulting_value_infos = new ArrayList<String>();
        this.table_headers = new ArrayList<String>();
        this.table_columns = new ArrayList<String>();
        this.table_column_callbacks = new HashMap<String, Callback>();
    }

    public OutputInformation() {
        this.initialize();
    }

    public OutputInformation(List<? extends ResultInfo> data) {
        this.initialize();
        this.data = data;
    }

    public void add_parameter(String param_name, String description, Object value) {
        this.parameter_descriptions.add(this.parameter_description_string(param_name, description));
        this.parameter_value_infos.add("# " + param_name + " = " + value.toString());
    }

    public void background_parameter(String param_name, String description, GeneralizedBackgroundModel background) {
        if (!background.is_wordwise()) {
            this.add_parameter(param_name, description, background.toString());
        }
    }

    public void add_table_parameter(String param_name, String description, String key_in_hash) {
        this.table_parameter_descriptions.add(this.parameter_description_string(param_name, description));
        this.add_table_parameter_without_description(param_name, key_in_hash);
    }

    public void add_table_parameter(String param_name, String description, String key_in_hash, Callback callback) {
        this.table_parameter_descriptions.add(this.parameter_description_string(param_name, description));
        this.add_table_parameter_without_description(param_name, key_in_hash, callback);
    }

    public void add_table_parameter_without_description(String param_name, String key_in_hash) {
        this.table_headers.add(param_name);
        this.table_columns.add(key_in_hash);
    }

    public void add_table_parameter_without_description(String param_name, String key_in_hash, Callback callback) {
        this.add_table_parameter_without_description(param_name, key_in_hash);
        this.table_column_callbacks.put(key_in_hash, callback);
    }

    String parameter_description_string(String param_name, String description) {
        return "# " + param_name + ": " + description;
    }

    public void add_resulting_value(String param_name, String description, Object value) {
        this.resulting_value_descriptions.add(this.parameter_description_string(param_name, description));
        this.resulting_value_infos.add(param_name + "\t" + value);
    }

    public String report() {
        ArrayList<List<String>> tmp = new ArrayList<List<String>>();
        tmp.add(this.parameters_info());
        tmp.add(this.resulting_values_info());
        tmp.add(this.resulting_table());
        ArrayList<String> results = new ArrayList<String>();
        for (List list : tmp) {
            if (list.isEmpty()) continue;
            results.add(StringExtensions.join(list, "\n"));
        }
        return StringExtensions.join(results, "\n#\n");
    }

    List<String> parameters_info() {
        ArrayList<String> result = new ArrayList<String>();
        for (String x : this.parameter_descriptions) {
            result.add(x);
        }
        for (String x : this.parameter_value_infos) {
            result.add(x);
        }
        return result;
    }

    List<String> resulting_values_info() {
        ArrayList<String> result = new ArrayList<String>();
        for (String x : this.resulting_value_descriptions) {
            result.add(x);
        }
        for (String x : this.resulting_value_infos) {
            result.add(x);
        }
        return result;
    }

    List<String> resulting_table() {
        if (this.data == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String x : this.table_parameter_descriptions) {
            result.add(x);
        }
        result.add(this.header_content());
        List<String> table_content = this.table_content();
        for (String x : table_content) {
            result.add(x);
        }
        return result;
    }

    String header_content() {
        return "# " + StringExtensions.join(this.table_headers, "\t");
    }

    String row_content(ResultInfo info) {
        ArrayList<String> cell_contents = new ArrayList<String>();
        for (String column_name : this.table_columns) {
            if (this.table_column_callbacks.containsKey(column_name)) {
                Callback callback = this.table_column_callbacks.get(column_name);
                cell_contents.add(callback.run(info).toString());
                continue;
            }
            cell_contents.add(info.get(column_name).toString());
        }
        return StringExtensions.join(cell_contents, "\t");
    }

    List<String> table_content() {
        ArrayList<String> result = new ArrayList<String>();
        for (ResultInfo resultInfo : this.data) {
            result.add(this.row_content(resultInfo));
        }
        return result;
    }

    public static interface Callback<T extends ResultInfo> {
        public Object run(T var1);
    }
}

