/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.examples;

import ru.autosome.perfectosape.Sequence;
import ru.autosome.perfectosape.backgroundModels.Background;
import ru.autosome.perfectosape.backgroundModels.BackgroundModel;
import ru.autosome.perfectosape.backgroundModels.DiBackground;
import ru.autosome.perfectosape.backgroundModels.DiBackgroundModel;
import ru.autosome.perfectosape.backgroundModels.GeneralizedBackgroundModel;
import ru.autosome.perfectosape.backgroundModels.WordwiseBackground;
import ru.autosome.perfectosape.calculations.HashOverflowException;
import ru.autosome.perfectosape.calculations.findPvalue.CanFindPvalue;
import ru.autosome.perfectosape.calculations.findPvalue.FindPvalueAPE;
import ru.autosome.perfectosape.importers.PMParser;
import ru.autosome.perfectosape.motifModels.DiPWM;
import ru.autosome.perfectosape.motifModels.PWM;

public class FindPvalueDinucleotide {
    static void print_result(CanFindPvalue.PvalueInfo info, GeneralizedBackgroundModel background, int pwmLength) {
        System.out.println("threshold: " + info.threshold + "\npvalue: " + info.pvalue + "\nnumber of recognized words: " + info.numberOfRecognizedWords(background, pwmLength) + "\n------------\n");
    }

    static void run_mono_and_di(PWM mono_pwm, BackgroundModel mono_background, Double discretization, Integer max_hash_size, double threshold) {
        DiPWM di_pwm = DiPWM.fromPWM(mono_pwm);
        DiBackgroundModel di_background = DiBackground.fromMonoBackground(mono_background);
        FindPvalueAPE<PWM, BackgroundModel> calculator = new FindPvalueAPE<PWM, BackgroundModel>(mono_pwm, mono_background, discretization, max_hash_size);
        FindPvalueAPE<DiPWM, DiBackgroundModel> dicalculator = new FindPvalueAPE<DiPWM, DiBackgroundModel>(di_pwm, di_background, discretization, max_hash_size);
        try {
            System.out.println("================");
            CanFindPvalue.PvalueInfo info = calculator.pvalueByThreshold(threshold);
            FindPvalueDinucleotide.print_result(info, mono_background, mono_pwm.length());
            CanFindPvalue.PvalueInfo di_info = dicalculator.pvalueByThreshold(threshold);
            FindPvalueDinucleotide.print_result(di_info, di_background, di_pwm.length());
            System.out.println("================");
        }
        catch (HashOverflowException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        PWM pwm = PWM.fromParser(PMParser.from_file_or_stdin("test_data/pwm/KLF4_f2.pwm"));
        double discretization = 10000.0;
        Integer max_hash_size = null;
        double threshold = 7.0;
        double[] thresholds = new double[]{3.0, 5.0, 7.0};
        Sequence word = new Sequence("ACAGTGACAA");
        DiPWM dipwm = DiPWM.fromPWM(pwm);
        System.out.println(pwm.score(word));
        System.out.println(dipwm.score(word));
        FindPvalueDinucleotide.run_mono_and_di(pwm, new WordwiseBackground(), discretization, max_hash_size, threshold);
        FindPvalueDinucleotide.run_mono_and_di(pwm, new Background(new double[]{0.1, 0.4, 0.4, 0.1}), discretization, max_hash_size, threshold);
        FindPvalueDinucleotide.run_mono_and_di(pwm, new Background(new double[]{0.25, 0.25, 0.25, 0.25}), discretization, max_hash_size, threshold);
    }
}

