/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.converters;

import ru.autosome.perfectosape.backgroundModels.GeneralizedBackgroundModel;
import ru.autosome.perfectosape.motifModels.BackgroundCompatible;
import ru.autosome.perfectosape.motifModels.Named;
import ru.autosome.perfectosape.motifModels.PositionCountModel;
import ru.autosome.perfectosape.motifModels.PositionWeightModel;

public class PCM2PWMConverter<ModelTypeFrom extends PositionCountModel & Named, ModelTypeTo extends PositionWeightModel & Named> {
    public GeneralizedBackgroundModel background;
    private final Double const_pseudocount;
    private final ModelTypeFrom pcm;
    private final Class<ModelTypeTo> toClass;

    public PCM2PWMConverter(ModelTypeFrom pcm, Class<ModelTypeTo> toClass) {
        this.pcm = pcm;
        this.background = ((BackgroundCompatible)pcm).compatibleBackground().wordwiseModel();
        this.const_pseudocount = null;
        this.toClass = toClass;
    }

    public PCM2PWMConverter(ModelTypeFrom pcm, double pseudocount, Class<ModelTypeTo> toClass) {
        this.pcm = pcm;
        this.background = ((BackgroundCompatible)pcm).compatibleBackground().wordwiseModel();
        this.const_pseudocount = pseudocount;
        this.toClass = toClass;
    }

    double count(double[] pos) {
        double count = 0.0;
        for (double element : pos) {
            count += element;
        }
        return count;
    }

    double pseudocount(double count) {
        return this.const_pseudocount != null ? this.const_pseudocount : Math.log(count);
    }

    double[] convert_position(double[] pos) {
        double count = this.count(pos);
        double pseudocount = this.pseudocount(count);
        double[] converted_pos = new double[this.pcm.alphabetSize()];
        for (int letter = 0; letter < this.pcm.alphabetSize(); ++letter) {
            double numerator = pos[letter] + this.background.probability(letter) * pseudocount;
            double denominator = this.background.probability(letter) * (count + pseudocount);
            converted_pos[letter] = Math.log(numerator / denominator);
        }
        return converted_pos;
    }

    public ModelTypeTo convert() {
        double[][] new_matrix = new double[this.pcm.getMatrix().length][];
        for (int pos = 0; pos < this.pcm.getMatrix().length; ++pos) {
            new_matrix[pos] = this.convert_position(this.pcm.getMatrix()[pos]);
        }
        try {
            return (ModelTypeTo)((PositionWeightModel)this.toClass.getConstructor(double[][].class, String.class).newInstance(new Object[]{new_matrix, ((Named)this.pcm).getName()}));
        }
        catch (Exception exception) {
            throw new Error("Shouldn't be here!", exception);
        }
    }
}

