/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.cli;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import ru.autosome.perfectosape.backgroundModels.DiBackground;
import ru.autosome.perfectosape.backgroundModels.DiBackgroundModel;
import ru.autosome.perfectosape.backgroundModels.DiWordwiseBackground;
import ru.autosome.perfectosape.backgroundModels.GeneralizedBackgroundModel;
import ru.autosome.perfectosape.calculations.findPvalue.CanFindPvalue;
import ru.autosome.perfectosape.calculations.findPvalue.FindPvalueAPE;
import ru.autosome.perfectosape.calculations.findPvalue.FindPvalueBsearchBuilder;
import ru.autosome.perfectosape.cli.FindPvalueGeneralized;
import ru.autosome.perfectosape.cli.Helper;
import ru.autosome.perfectosape.importers.DiPWMImporter;
import ru.autosome.perfectosape.motifModels.DiPWM;
import ru.autosome.perfectosape.motifModels.Named;
import ru.autosome.perfectosape.motifModels.ScoringModel;

public class DiPWMFindPvalue
extends FindPvalueGeneralized<DiPWM, DiBackgroundModel> {
    @Override
    protected String DOC_background_option() {
        return "ACGT - 16 numbers, comma-delimited(spaces not allowed), sum should be equal to 1, like 0.2,0.3,0.3,0.2,0.2,0.3,0.3,0.2,0.2,0.3,0.3,0.2,0.2,0.3,0.3,0.2";
    }

    @Override
    protected String DOC_run_string() {
        return "java ru.autosome.perfectosape.cli.DiPWMFindPvalue";
    }

    @Override
    protected CanFindPvalue calculator() throws FileNotFoundException {
        if (this.cache_calculator == null) {
            this.cache_calculator = this.thresholds_folder == null ? new FindPvalueAPE<ScoringModel, GeneralizedBackgroundModel>(this.motif, this.background, this.discretization, this.max_hash_size) : new FindPvalueBsearchBuilder(this.thresholds_folder).pvalueCalculator((Named)((Object)this.motif));
        }
        return this.cache_calculator;
    }

    @Override
    protected void initialize_default_background() {
        this.background = new DiWordwiseBackground();
    }

    @Override
    protected void extract_background(String str) {
        this.background = DiBackground.fromString(str);
    }

    protected DiPWMImporter motifImporter() {
        return new DiPWMImporter((DiBackgroundModel)this.background, this.data_model, this.effective_count);
    }

    protected DiPWMFindPvalue() {
        this.initialize_defaults();
    }

    protected static DiPWMFindPvalue from_arglist(ArrayList<String> argv) {
        DiPWMFindPvalue result = new DiPWMFindPvalue();
        Helper.print_help_if_requested(argv, result.documentString());
        result.setup_from_arglist(argv);
        return result;
    }

    protected static DiPWMFindPvalue from_arglist(String[] args) {
        ArrayList<String> argv = new ArrayList<String>();
        Collections.addAll(argv, args);
        return DiPWMFindPvalue.from_arglist(argv);
    }

    public static void main(String[] args) {
        try {
            DiPWMFindPvalue cli = DiPWMFindPvalue.from_arglist(args);
            System.out.println(cli.report_table().report());
        }
        catch (Exception err) {
            System.err.println("\n" + err.getMessage() + "\n--------------------------------------\n");
            err.printStackTrace();
            System.err.println("\n--------------------------------------\nUse --help option for help\n\n" + new DiPWMFindPvalue().documentString());
            System.exit(1);
        }
    }
}

