/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.calculations.findPvalue;

import gnu.trove.map.TDoubleDoubleMap;
import ru.autosome.perfectosape.backgroundModels.GeneralizedBackgroundModel;
import ru.autosome.perfectosape.calculations.HashOverflowException;
import ru.autosome.perfectosape.calculations.ScoringModelDistributions.ScoringModelDistibutions;
import ru.autosome.perfectosape.calculations.findPvalue.CanFindPvalue;
import ru.autosome.perfectosape.formatters.OutputInformation;
import ru.autosome.perfectosape.motifModels.Discretable;
import ru.autosome.perfectosape.motifModels.ScoringModel;

public abstract class FindPvalueByDiscretization<ModelType extends Discretable<ModelType> & ScoringModel, BackgroundType extends GeneralizedBackgroundModel>
implements CanFindPvalue {
    Double discretization;
    ModelType motif;
    BackgroundType background;

    abstract ScoringModelDistibutions discretedScoringModel();

    FindPvalueByDiscretization(ModelType motif, BackgroundType background, Double discretization) {
        this.motif = motif;
        this.background = background;
        this.discretization = discretization;
    }

    private double upscale_threshold(double threshold) {
        if (this.discretization == null) {
            return threshold;
        }
        return threshold * this.discretization;
    }

    private double[] upscaled_thresholds(double[] thresholds) {
        double[] result = new double[thresholds.length];
        for (int i = 0; i < thresholds.length; ++i) {
            result[i] = this.upscale_threshold(thresholds[i]);
        }
        return result;
    }

    CanFindPvalue.PvalueInfo infos_by_count(TDoubleDoubleMap counts, double non_upscaled_threshold) {
        double count = counts.get(this.upscale_threshold(non_upscaled_threshold));
        double vocabularyVolume = Math.pow(this.background.volume(), ((ScoringModel)this.motif).length());
        double pvalue = count / vocabularyVolume;
        return new CanFindPvalue.PvalueInfo(non_upscaled_threshold, pvalue);
    }

    @Override
    public CanFindPvalue.PvalueInfo[] pvaluesByThresholds(double[] thresholds) throws HashOverflowException {
        TDoubleDoubleMap counts = this.discretedScoringModel().counts_above_thresholds(this.upscaled_thresholds(thresholds));
        CanFindPvalue.PvalueInfo[] infos = new CanFindPvalue.PvalueInfo[thresholds.length];
        for (int i = 0; i < thresholds.length; ++i) {
            infos[i] = this.infos_by_count(counts, thresholds[i]);
        }
        return infos;
    }

    @Override
    public CanFindPvalue.PvalueInfo pvalueByThreshold(double threshold) throws HashOverflowException {
        double[] thresholds = new double[]{threshold};
        return this.pvaluesByThresholds(thresholds)[0];
    }

    @Override
    public OutputInformation report_table_layout() {
        OutputInformation infos = new OutputInformation();
        infos.add_parameter("V", "discretization value", this.discretization);
        infos.background_parameter("B", "background", (GeneralizedBackgroundModel)this.background);
        infos.add_table_parameter("T", "threshold", "threshold");
        if (this.background.is_wordwise()) {
            infos.add_table_parameter("W", "number of recognized words", "numberOfRecognizedWords", new OutputInformation.Callback<CanFindPvalue.PvalueInfo>(){

                @Override
                public Object run(CanFindPvalue.PvalueInfo cell) {
                    double numberOfRecognizedWords = cell.numberOfRecognizedWords((GeneralizedBackgroundModel)FindPvalueByDiscretization.this.background, ((ScoringModel)FindPvalueByDiscretization.this.motif).length());
                    return (long)numberOfRecognizedWords;
                }
            });
        }
        infos.add_table_parameter("P", "P-value", "pvalue");
        return infos;
    }
}

