/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.assist;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.autosome.assist.ASequence;

public abstract class AMatrix {
    protected double[][] matrix;
    protected double N;
    protected int length;
    static final double A0 = 0.08333333333333333;
    static final double A1 = 0.03333333333333333;
    static final double A2 = 0.2523809523809524;
    static final double A3 = 0.5256064690026954;
    static final double A4 = 1.0115230681268417;
    static final double A5 = 1.5174736491532874;
    static final double A6 = 2.2694889742049598;
    private static final Map<Character, Character> IUPACC = Collections.synchronizedMap(new HashMap());
    public static final Map<String, String> CONSENSUS;

    public void setN(double n) {
        this.N = n;
    }

    public double getN() {
        return this.N;
    }

    public double[][] getMatrix() {
        return this.matrix;
    }

    public static double logFact(double f) {
        if (f <= 1.0) {
            return 0.0;
        }
        double z_big = f + 1.0;
        return 0.5 * Math.log(Math.PI * 2) + (z_big - 0.5) * Math.log(z_big) - z_big + 0.08333333333333333 / (z_big + 0.03333333333333333 / (z_big + 0.2523809523809524 / (z_big + 0.5256064690026954 / (z_big + 1.0115230681268417 / (z_big + 1.5174736491532874 / (z_big + 2.2694889742049598 / z_big))))));
    }

    public double score(byte[] seq, double[] profile, int offset) {
        double score = 0.0;
        for (int i = 0; i < this.length; ++i) {
            score += this.matrix[seq[offset + i]][i] * profile[offset + i];
        }
        return score;
    }

    public double score(byte[] seq, int seqoffset) {
        double score = 0.0;
        for (int i = 0; i < this.length; ++i) {
            score += this.matrix[seq[seqoffset + i]][i];
        }
        return score;
    }

    public double score(byte[] word) {
        double score = 0.0;
        for (int i = 0; i < word.length; ++i) {
            score += this.matrix[word[i]][i];
        }
        return score;
    }

    public double bestScore() {
        double result = 0.0;
        for (int i = 0; i < this.length; ++i) {
            result += Math.max(this.matrix[0][i], Math.max(this.matrix[1][i], Math.max(this.matrix[2][i], this.matrix[3][i])));
        }
        return result;
    }

    public double bestScore(ASequence sequence, List<Integer> primaryHit, List<Integer> revcompHit) {
        double bestScore = -1.7976931348623157E308;
        for (Integer i : primaryHit) {
            bestScore = Math.max(this.score(sequence.direct, i), bestScore);
        }
        for (Integer i : revcompHit) {
            bestScore = Math.max(this.score(sequence.revcomp, i), bestScore);
        }
        return bestScore;
    }

    public static String revcomp(String s) {
        char[] cs = s.toCharArray();
        for (int i = 0; i < cs.length; ++i) {
            cs[i] = IUPACC.get(Character.valueOf(cs[i])).charValue();
        }
        return new StringBuffer(new String(cs)).reverse().toString();
    }

    public double hits(byte[] direct, byte[] revcomp, double[] hdirect, double[] hrevcomp) {
        double rs;
        hdirect[0] = this.score(direct, 0);
        double ds = hdirect[0];
        double best_hit = ds >= (rs = (hrevcomp[0] = this.score(revcomp, 0))) ? ds : rs;
        for (int i = 1; i <= direct.length - this.length; ++i) {
            hdirect[i] = ds = this.score(direct, i);
            hrevcomp[i] = rs = this.score(revcomp, i);
            double hit = ds >= rs ? ds : rs;
            best_hit = best_hit >= hit ? best_hit : hit;
        }
        return best_hit;
    }

    public double hits(byte[] direct, byte[] revcomp, double[] hdirect, double[] hrevcomp, double[] pdirect, double[] prevcomp) {
        double rs;
        hdirect[0] = this.score(direct, pdirect, 0);
        double ds = hdirect[0];
        double best_hit = ds >= (rs = (hrevcomp[0] = this.score(revcomp, prevcomp, 0))) ? ds : rs;
        for (int i = 1; i <= direct.length - this.length; ++i) {
            hdirect[i] = ds = this.score(direct, pdirect, i);
            hrevcomp[i] = rs = this.score(revcomp, prevcomp, i);
            double hit = ds >= rs ? ds : rs;
            best_hit = best_hit >= hit ? best_hit : hit;
        }
        return best_hit;
    }

    public double hits(byte[] direct, double[] hdirect, double[] pdirect) {
        double best_hit = hdirect[0] = this.score(direct, pdirect, 0);
        for (int i = 1; i <= direct.length - this.length; ++i) {
            hdirect[i] = this.score(direct, pdirect, i);
            best_hit = best_hit >= hdirect[i] ? best_hit : hdirect[i];
        }
        return best_hit;
    }

    public double m3sd() {
        return this.scoreMean() + 3.0 * Math.sqrt(this.scoreVariance());
    }

    public double scoreMean() {
        double mean = 0.0;
        for (int j = 0; j < this.length; ++j) {
            for (int i = 0; i < 4; ++i) {
                mean += this.matrix[i][j] * 0.25;
            }
        }
        return mean;
    }

    public double scoreVariance() {
        double variance = 0.0;
        for (int j = 0; j < this.length; ++j) {
            double m2 = 0.0;
            double _2m = 0.0;
            for (int i = 0; i < 4; ++i) {
                m2 += this.matrix[i][j] * this.matrix[i][j] * 0.25;
                _2m += this.matrix[i][j] * 0.25;
            }
            variance += m2 - _2m * _2m;
        }
        return variance;
    }

    public int length() {
        return this.length;
    }

    public double[][] matrix() {
        return this.matrix;
    }

    public abstract AMatrix makePWM(double[] var1);

    static {
        IUPACC.put(Character.valueOf('A'), Character.valueOf('T'));
        IUPACC.put(Character.valueOf('C'), Character.valueOf('G'));
        IUPACC.put(Character.valueOf('G'), Character.valueOf('C'));
        IUPACC.put(Character.valueOf('T'), Character.valueOf('A'));
        IUPACC.put(Character.valueOf('R'), Character.valueOf('Y'));
        IUPACC.put(Character.valueOf('Y'), Character.valueOf('R'));
        IUPACC.put(Character.valueOf('K'), Character.valueOf('M'));
        IUPACC.put(Character.valueOf('M'), Character.valueOf('K'));
        IUPACC.put(Character.valueOf('S'), Character.valueOf('S'));
        IUPACC.put(Character.valueOf('W'), Character.valueOf('W'));
        IUPACC.put(Character.valueOf('B'), Character.valueOf('V'));
        IUPACC.put(Character.valueOf('D'), Character.valueOf('H'));
        IUPACC.put(Character.valueOf('H'), Character.valueOf('D'));
        IUPACC.put(Character.valueOf('V'), Character.valueOf('B'));
        IUPACC.put(Character.valueOf('N'), Character.valueOf('N'));
        CONSENSUS = Collections.synchronizedMap(new HashMap());
        CONSENSUS.put("A", "A");
        CONSENSUS.put("C", "C");
        CONSENSUS.put("G", "G");
        CONSENSUS.put("T", "T");
        CONSENSUS.put("AG", "R");
        CONSENSUS.put("CT", "Y");
        CONSENSUS.put("GT", "K");
        CONSENSUS.put("AC", "M");
        CONSENSUS.put("CG", "S");
        CONSENSUS.put("AT", "W");
        CONSENSUS.put("CGT", "B");
        CONSENSUS.put("AGT", "D");
        CONSENSUS.put("ACG", "V");
        CONSENSUS.put("ACT", "H");
        CONSENSUS.put("ACGT", "N");
    }
}

