/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.importers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayDeque;
import java.util.Deque;

public class BufferedPushbackReader
extends BufferedReader {
    private BufferedReader reader;
    private Deque<Character> buf = new ArrayDeque<Character>();

    public BufferedPushbackReader(InputStream in) {
        super(new InputStreamReader(in));
        this.reader = new BufferedReader(new InputStreamReader(in));
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int res;
        int numRead = 0;
        int pos = off;
        while (pos < off + len && !this.buf.isEmpty()) {
            cbuf[pos] = this.buf.pop().charValue();
            ++pos;
            ++numRead;
        }
        if (pos < off + len && (res = this.reader.read(cbuf, pos, len - (pos - off))) > 0) {
            numRead += res;
        }
        return numRead > 0 ? numRead : -1;
    }

    @Override
    public int read() throws IOException {
        if (!this.buf.isEmpty()) {
            return this.buf.pop().charValue();
        }
        return this.reader.read();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        int pos = 0;
        while (!this.buf.isEmpty()) {
            cbuf[pos] = this.buf.pop().charValue();
            ++pos;
        }
        boolean eof = false;
        while (!eof) {
            int c = this.reader.read();
            if (c == -1) {
                eof = true;
                continue;
            }
            cbuf[pos] = (char)c;
            ++pos;
        }
        return pos > 0 ? pos : -1;
    }

    @Override
    public String readLine() throws IOException {
        StringBuilder builder = new StringBuilder();
        boolean lineEnded = false;
        while (!lineEnded) {
            int c = this.read();
            if (c == -1) {
                lineEnded = true;
                continue;
            }
            if (c == 13 || c == 10) {
                lineEnded = true;
                this.unread(c);
                continue;
            }
            builder.append((char)c);
        }
        this.eatEndOfLine();
        return builder.toString();
    }

    public boolean eatEndOfLine() throws IOException {
        int c = this.read();
        if (c == -1) {
            return false;
        }
        if (c == 10) {
            return true;
        }
        if (c == 13) {
            int next_c = this.read();
            if (next_c != -1 && next_c != 10) {
                this.unread(next_c);
            }
            return true;
        }
        this.unread(c);
        return false;
    }

    @Override
    public void close() throws IOException {
        this.buf.clear();
        this.reader.close();
    }

    public void unread(char[] cbuf, int off, int len) throws IOException {
        for (int pos = off + len - 1; pos >= off; --pos) {
            this.buf.push(Character.valueOf(cbuf[pos]));
        }
    }

    public void unread(char[] cbuf) throws IOException {
        this.unread(cbuf, 0, cbuf.length);
    }

    public void unread(int c) throws IOException {
        this.buf.push(Character.valueOf((char)c));
    }

    public void unreadLine(String s) throws IOException {
        this.unread((s + "\n").toCharArray());
    }
}

