/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.converters;

import ru.autosome.perfectosape.motifModels.Named;
import ru.autosome.perfectosape.motifModels.PositionCountModel;
import ru.autosome.perfectosape.motifModels.PositionFrequencyModel;

public class PPM2PCMConverter<ModelTypeFrom extends PositionFrequencyModel & Named, ModelTypeTo extends PositionCountModel & Named> {
    private final ModelTypeFrom ppm;
    private final double count;
    private final Class<ModelTypeTo> toClass;

    public PPM2PCMConverter(ModelTypeFrom ppm, double count, Class<ModelTypeTo> toClass) {
        this.ppm = ppm;
        this.count = count;
        this.toClass = toClass;
    }

    double[] convert_position(double[] pos) {
        double[] converted_pos = new double[this.ppm.alphabetSize()];
        for (int letter = 0; letter < this.ppm.alphabetSize(); ++letter) {
            converted_pos[letter] = pos[letter] * this.count;
        }
        return converted_pos;
    }

    public ModelTypeTo convert() {
        double[][] new_matrix = new double[this.ppm.getMatrix().length][];
        for (int pos = 0; pos < this.ppm.getMatrix().length; ++pos) {
            new_matrix[pos] = this.convert_position(this.ppm.getMatrix()[pos]);
        }
        try {
            return (ModelTypeTo)((PositionCountModel)this.toClass.getConstructor(double[][].class).newInstance(new Object[]{new_matrix, ((Named)this.ppm).getName()}));
        }
        catch (Exception exception) {
            throw new Error("Shouldn't be here!", exception);
        }
    }
}

