/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.cli;

import java.util.ArrayList;
import java.util.Collections;
import ru.autosome.perfectosape.BoundaryType;
import ru.autosome.perfectosape.backgroundModels.Background;
import ru.autosome.perfectosape.backgroundModels.BackgroundModel;
import ru.autosome.perfectosape.backgroundModels.WordwiseBackground;
import ru.autosome.perfectosape.calculations.ComparePWM;
import ru.autosome.perfectosape.calculations.HashOverflowException;
import ru.autosome.perfectosape.calculations.findPvalue.FindPvalueAPE;
import ru.autosome.perfectosape.calculations.findThreshold.FindThresholdAPE;
import ru.autosome.perfectosape.cli.Helper;
import ru.autosome.perfectosape.formatters.OutputInformation;
import ru.autosome.perfectosape.importers.PMParser;
import ru.autosome.perfectosape.importers.PWMImporter;
import ru.autosome.perfectosape.motifModels.DataModel;
import ru.autosome.perfectosape.motifModels.PWM;

public class EvalSimilarity {
    private static final String DOC = "Command-line format:\njava ru.autosome.perfectosape.cli.EvalSimilarity <1st matrix pat-file> <2nd matrix pat-file> [options]\n\nOptions:\n  [-p <P-value>]\n  [-d <discretization level>]\n  [--pcm] - treat the input file as Position Count Matrix. PCM-to-PWM transformation to be done internally.\n  [--ppm] or [--pfm] - treat the input file as Position Frequency Matrix. PPM-to-PWM transformation to be done internally.\n  [--effective-count <count>] - effective samples set size for PPM-to-PWM conversion (default: 100). \n  [--boundary lower|upper] Upper boundary (default) means that the obtained P-value is greater than or equal to the requested P-value\n  [-b <background probabilities] ACGT - 4 numbers, comma-delimited(spaces not allowed), sum should be equal to 1, like 0.25,0.24,0.26,0.25\n  [--first-threshold <threshold for the first matrix>]\n  [--second-threshold <threshold for the second matrix>]\n\nExamples:\n  java ru.autosome.perfectosape.cli.EvalSimilarity motifs/KLF4_f2.pat motifs/SP1_f1.pat -p 0.0005 -d 100 -b 0.3,0.2,0.2,0.3\n";
    private BackgroundModel firstBackground;
    private BackgroundModel secondBackground;
    private Double discretization;
    private double pvalue;
    private BoundaryType pvalueBoundary;
    private String firstPMFilename;
    private String secondPMFilename;
    private DataModel dataModelFirst;
    private DataModel dataModelSecond;
    private Integer maxHashSize;
    private Integer maxPairHashSize;
    private Double effectiveCountFirst;
    private Double effectiveCountSecond;
    private Double predefinedFirstThreshold;
    private Double predefinedSecondThreshold;
    private PWM firstPWM;
    private PWM secondPWM;
    private Double cacheFirstThreshold;
    private Double cacheSecondThreshold;

    private void extract_first_pm_filename(ArrayList<String> argv) {
        if (argv.isEmpty()) {
            throw new IllegalArgumentException("No input. You should specify input file");
        }
        this.firstPMFilename = argv.remove(0);
    }

    private void extract_second_pm_filename(ArrayList<String> argv) {
        if (argv.isEmpty()) {
            throw new IllegalArgumentException("No input. You should specify input file");
        }
        this.secondPMFilename = argv.remove(0);
    }

    private void initialize_defaults() {
        this.firstBackground = new WordwiseBackground();
        this.secondBackground = new WordwiseBackground();
        this.dataModelFirst = DataModel.PWM;
        this.dataModelSecond = DataModel.PWM;
        this.effectiveCountFirst = 100.0;
        this.effectiveCountSecond = 100.0;
        this.pvalue = 5.0E-4;
        this.discretization = 10.0;
        this.maxHashSize = 10000000;
        this.maxPairHashSize = 10000;
        this.pvalueBoundary = BoundaryType.UPPER;
    }

    private void extract_option(ArrayList<String> argv) {
        String opt = argv.remove(0);
        if (opt.equals("-b")) {
            BackgroundModel background;
            this.firstBackground = background = Background.fromString(argv.remove(0));
            this.secondBackground = background;
        } else if (opt.equals("-p")) {
            this.pvalue = Double.valueOf(argv.remove(0));
        } else if (opt.equals("-b1")) {
            this.firstBackground = Background.fromString(argv.remove(0));
        } else if (opt.equals("-b2")) {
            this.secondBackground = Background.fromString(argv.remove(0));
        } else if (opt.equals("--max-hash-size")) {
            this.maxHashSize = Integer.valueOf(argv.remove(0));
        } else if (opt.equals("--max-2d-hash-size")) {
            this.maxPairHashSize = Integer.valueOf(argv.remove(0));
        } else if (opt.equals("-d")) {
            this.discretization = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--boundary")) {
            this.pvalueBoundary = BoundaryType.valueOf(argv.remove(0).toUpperCase());
        } else if (opt.equals("--pcm")) {
            this.dataModelFirst = DataModel.PCM;
            this.dataModelSecond = DataModel.PCM;
        } else if (opt.equals("--ppm") || opt.equals("--pfm")) {
            this.dataModelFirst = DataModel.PPM;
            this.dataModelSecond = DataModel.PPM;
        } else if (opt.equals("--effective-count")) {
            Double effectiveCount;
            this.effectiveCountFirst = effectiveCount = Double.valueOf(argv.remove(0));
            this.effectiveCountSecond = effectiveCount;
        } else if (opt.equals("--first-threshold")) {
            this.predefinedFirstThreshold = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--second-threshold")) {
            this.predefinedSecondThreshold = Double.valueOf(argv.remove(0));
        } else {
            throw new IllegalArgumentException("Unknown option '" + opt + "'");
        }
    }

    void setup_from_arglist(ArrayList<String> argv) {
        this.extract_first_pm_filename(argv);
        this.extract_second_pm_filename(argv);
        while (argv.size() > 0) {
            this.extract_option(argv);
        }
        this.firstPWM = (PWM)new PWMImporter(this.firstBackground, this.dataModelFirst, this.effectiveCountFirst).loadPWMFromParser(PMParser.from_file_or_stdin(this.firstPMFilename));
        this.secondPWM = (PWM)new PWMImporter(this.secondBackground, this.dataModelSecond, this.effectiveCountSecond).loadPWMFromParser(PMParser.from_file_or_stdin(this.secondPMFilename));
    }

    private EvalSimilarity() {
        this.initialize_defaults();
    }

    private static EvalSimilarity from_arglist(ArrayList<String> argv) {
        EvalSimilarity result = new EvalSimilarity();
        Helper.print_help_if_requested(argv, DOC);
        result.setup_from_arglist(argv);
        return result;
    }

    private static EvalSimilarity from_arglist(String[] args) {
        ArrayList<String> argv = new ArrayList<String>();
        Collections.addAll(argv, args);
        return EvalSimilarity.from_arglist(argv);
    }

    ComparePWM calculator() {
        ComparePWM result = new ComparePWM(this.firstPWM, this.secondPWM, this.firstBackground, this.secondBackground, new FindPvalueAPE<PWM, BackgroundModel>(this.firstPWM, this.firstBackground, this.discretization, this.maxHashSize), new FindPvalueAPE<PWM, BackgroundModel>(this.secondPWM, this.secondBackground, this.discretization, this.maxHashSize), this.discretization, this.maxPairHashSize);
        return result;
    }

    OutputInformation report_table_layout() {
        OutputInformation infos = new OutputInformation();
        infos.add_parameter("V", "discretization", this.discretization);
        if (this.predefinedFirstThreshold == null || this.predefinedSecondThreshold == null) {
            infos.add_parameter("P", "requested P-value", this.pvalue);
        }
        if (this.predefinedFirstThreshold != null) {
            infos.add_parameter("T1", "threshold for the 1st matrix", this.predefinedFirstThreshold);
        }
        if (this.predefinedSecondThreshold != null) {
            infos.add_parameter("T2", "threshold for the 2nd matrix", this.predefinedSecondThreshold);
        }
        infos.add_parameter("PB", "P-value boundary", (Object)this.pvalueBoundary);
        if (this.firstBackground.equals(this.secondBackground)) {
            infos.background_parameter("B", "background", this.firstBackground);
        } else {
            infos.background_parameter("B1", "background for the 1st model", this.firstBackground);
            infos.background_parameter("B2", "background for the 2nd model", this.secondBackground);
        }
        return infos;
    }

    OutputInformation report_table(ComparePWM.SimilarityInfo info) throws HashOverflowException {
        OutputInformation infos = this.report_table_layout();
        infos.add_resulting_value("S", "similarity", info.similarity());
        infos.add_resulting_value("D", "distance (1-similarity)", info.distance());
        infos.add_resulting_value("L", "length of the alignment", info.alignment.length());
        infos.add_resulting_value("SH", "shift of the 2nd PWM relative to the 1st", info.alignment.shift());
        infos.add_resulting_value("OR", "orientation of the 2nd PWM relative to the 1st", info.alignment.orientation());
        infos.add_resulting_value("A1", "aligned 1st matrix", info.alignment.first_pwm_alignment());
        infos.add_resulting_value("A2", "aligned 2nd matrix", info.alignment.second_pwm_alignment());
        infos.add_resulting_value("W", "number of words recognized by both models (model = PWM + threshold)", info.recognizedByBoth);
        infos.add_resulting_value("W1", "number of words and recognized by the first model", info.recognizedByFirst);
        infos.add_resulting_value("P1", "P-value for the 1st matrix", info.realPvalueFirst(this.firstBackground));
        if (this.predefinedFirstThreshold == null) {
            infos.add_resulting_value("T1", "threshold for the 1st matrix", this.thresholdFirst());
        }
        infos.add_resulting_value("W2", "number of words recognized by the 2nd model", info.recognizedBySecond);
        infos.add_resulting_value("P2", "P-value for the 2nd matrix", info.realPvalueSecond(this.secondBackground));
        if (this.predefinedSecondThreshold == null) {
            infos.add_resulting_value("T2", "threshold for the 2nd matrix", this.thresholdSecond());
        }
        return infos;
    }

    double thresholdFirst() throws HashOverflowException {
        if (this.cacheFirstThreshold == null) {
            if (this.predefinedFirstThreshold != null) {
                this.cacheFirstThreshold = this.predefinedFirstThreshold;
            } else {
                FindThresholdAPE<PWM, BackgroundModel> pvalue_calculator = new FindThresholdAPE<PWM, BackgroundModel>(this.firstPWM, this.firstBackground, this.discretization, this.maxHashSize);
                this.cacheFirstThreshold = pvalue_calculator.thresholdByPvalue((double)this.pvalue, (BoundaryType)this.pvalueBoundary).threshold;
            }
        }
        return this.cacheFirstThreshold;
    }

    double thresholdSecond() throws HashOverflowException {
        if (this.cacheSecondThreshold == null) {
            if (this.predefinedSecondThreshold != null) {
                this.cacheSecondThreshold = this.predefinedSecondThreshold;
            } else {
                FindThresholdAPE<PWM, BackgroundModel> pvalue_calculator = new FindThresholdAPE<PWM, BackgroundModel>(this.secondPWM, this.secondBackground, this.discretization, this.maxHashSize);
                this.cacheSecondThreshold = pvalue_calculator.thresholdByPvalue((double)this.pvalue, (BoundaryType)this.pvalueBoundary).threshold;
            }
        }
        return this.cacheSecondThreshold;
    }

    OutputInformation report_table() throws Exception {
        ComparePWM.SimilarityInfo results = this.calculator().jaccard(this.thresholdFirst(), this.thresholdSecond());
        return this.report_table(results);
    }

    public static void main(String[] args) {
        try {
            EvalSimilarity cli = EvalSimilarity.from_arglist(args);
            System.out.println(cli.report_table().report());
        }
        catch (Exception err) {
            System.err.println("\n" + err.getMessage() + "\n--------------------------------------\n");
            err.printStackTrace();
            System.err.println("\n--------------------------------------\nUse --help option for help\n\nCommand-line format:\njava ru.autosome.perfectosape.cli.EvalSimilarity <1st matrix pat-file> <2nd matrix pat-file> [options]\n\nOptions:\n  [-p <P-value>]\n  [-d <discretization level>]\n  [--pcm] - treat the input file as Position Count Matrix. PCM-to-PWM transformation to be done internally.\n  [--ppm] or [--pfm] - treat the input file as Position Frequency Matrix. PPM-to-PWM transformation to be done internally.\n  [--effective-count <count>] - effective samples set size for PPM-to-PWM conversion (default: 100). \n  [--boundary lower|upper] Upper boundary (default) means that the obtained P-value is greater than or equal to the requested P-value\n  [-b <background probabilities] ACGT - 4 numbers, comma-delimited(spaces not allowed), sum should be equal to 1, like 0.25,0.24,0.26,0.25\n  [--first-threshold <threshold for the first matrix>]\n  [--second-threshold <threshold for the second matrix>]\n\nExamples:\n  java ru.autosome.perfectosape.cli.EvalSimilarity motifs/KLF4_f2.pat motifs/SP1_f1.pat -p 0.0005 -d 100 -b 0.3,0.2,0.2,0.3\n");
            System.exit(1);
        }
    }
}

