/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.di.ytilib;

import java.util.List;
import org.apache.commons.math3.distribution.BinomialDistribution;
import ru.autosome.assist.AMunkResult;
import ru.autosome.assist.WordRecord;
import ru.autosome.di.ytilib.PerfectosPvalue;
import ru.autosome.di.ytilib.Sequence;
import ru.autosome.di.ytilib.WPCM;

public class MunkResult
extends AMunkResult {
    public MunkResult(List<WordRecord> wordList, WPCM pm, double[] background, int seqsUsed, int seqsTotal, double medianSeqLength) {
        super(wordList, pm, background, seqsUsed, seqsTotal, medianSeqLength);
    }

    @Override
    protected double estimatePvalue() {
        PerfectosPvalue pp = new PerfectosPvalue((WPCM)this.pwm, this.background);
        double pv = pp.PointPvalue(this.threshold);
        double chancePerSeq = 1.0 - Math.pow(1.0 - pv, this.medianSeqLength * 2.0);
        BinomialDistribution bd = new BinomialDistribution(this.seqsTotal, chancePerSeq);
        double p1 = 1.0 - bd.cumulativeProbability(this.seqsUsed - 1);
        return p1;
    }

    @Override
    protected String word2str(WordRecord r) {
        return Sequence.seq2str(r.getWord());
    }

    @Override
    public WPCM getWPCM() {
        return (WPCM)this.wpcm;
    }

    @Override
    public WPCM getPWM() {
        return (WPCM)this.pwm;
    }
}

