/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.assist;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import ru.autosome.assist.AMatrix;
import ru.autosome.assist.Conductor;
import ru.autosome.assist.WordRecord;

public abstract class AMunkResult {
    protected double threshold;
    protected List<WordRecord> wordList;
    protected AMatrix wpcm;
    protected AMatrix pwm;
    protected int seqsUsed;
    protected int seqsTotal;
    protected double medianSeqLength;
    protected double[] background;
    private String diagnosis;
    private Double pvalue = null;

    public AMunkResult(List<WordRecord> wordList, AMatrix pm, double[] background, int seqsUsed, int seqsTotal, double medianSeqLength) {
        Collections.sort(wordList, new Comparator<WordRecord>(){

            @Override
            public int compare(WordRecord o1, WordRecord o2) {
                return o2.score.compareTo(o1.score);
            }
        });
        this.wordList = wordList;
        this.seqsUsed = seqsUsed;
        this.seqsTotal = seqsTotal;
        this.medianSeqLength = medianSeqLength;
        this.wpcm = pm;
        this.pwm = pm.makePWM(background);
        this.background = background;
        this.threshold = wordList.get((int)(wordList.size() - 1)).score;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void printout(Conductor conductor, boolean verbose) {
        conductor.output("TOTL", this.seqsTotal);
        conductor.output("WRDS", this.wordList.size());
        conductor.output("SEQS", this.seqsUsed);
        conductor.output("COVR", (double)this.seqsUsed / (double)this.seqsTotal);
        if (verbose) {
            conductor.output("LIST", "seq#\tpos#\tword\tscore\tstrand\tweight");
            for (WordRecord r : this.wordList) {
                conductor.output("WORD", "" + r.sequenceIndex + "\t" + r.position + "\t" + this.word2str(r) + "\t" + r.score + "\t" + r.strand + "\t" + r.weight);
            }
        }
    }

    protected abstract String word2str(WordRecord var1);

    public AMatrix getWPCM() {
        return this.wpcm;
    }

    public AMatrix getPWM() {
        return this.pwm;
    }

    public double[] getBackground() {
        return this.background;
    }

    public void setDiagnosis(String diagnosis) {
        this.diagnosis = diagnosis;
    }

    public String getDiagnosis() {
        return this.diagnosis;
    }

    public double pvalue() {
        if (this.pvalue != null) {
            return this.pvalue;
        }
        this.pvalue = this.estimatePvalue();
        return this.pvalue;
    }

    protected abstract double estimatePvalue();
}

