package ru.autosome.assist;

import java.util.Comparator;
import java.util.List;

public abstract class AMunkResult {

  protected double threshold;
  protected List<WordRecord> wordList;
  protected AMatrix wpcm;
  protected AMatrix pwm;
  protected int seqsUsed;
  protected int seqsTotal;
  protected double medianSeqLength;
  protected double[] background;
  private String diagnosis;

  public AMunkResult(List<WordRecord> wordList, AMatrix pm, double[] background, int seqsUsed, int seqsTotal, double medianSeqLength) {
    java.util.Collections.sort(wordList, new Comparator<WordRecord>() {
      public int compare(WordRecord o1, WordRecord o2) {
        return o2.score.compareTo(o1.score);
      }
    });

    this.wordList = wordList;
    this.seqsUsed = seqsUsed;
    this.seqsTotal = seqsTotal;
    this.medianSeqLength = medianSeqLength;
    this.wpcm = pm;
    this.pwm = pm.makePWM(background);
    this.background = background;
    // for (WordRecord r: wordList) r.score = pwm.score(r.word);
    this.threshold = wordList.get(wordList.size()-1).score;
  }

  /*public void setPM(WPCM pm, double[] background) {
    this.pm = pm;
    WPCM pwm = new WPCM(pm).toPWM(background);
    for (WordRecord r: wordList) r.score = pwm.score(r.word);
  }*/

  public double getThreshold() {
    return threshold;
  }

  public void printout(Conductor conductor, boolean verbose) {

    conductor.output("TOTL", seqsTotal);
    conductor.output("WRDS", wordList.size());
    conductor.output("SEQS", seqsUsed);
    conductor.output("COVR", (double)seqsUsed / (double)seqsTotal );

    if (verbose) {
      conductor.output("LIST", "seq#\tpos#\tword\tscore\tstrand\tweight");
      for (WordRecord r: wordList) {
        conductor.output("WORD", "" + r.sequenceIndex + "\t" + r.position + "\t" + word2str(r) + "\t" + r.score + "\t" + r.strand + "\t" + r.weight);
      }
    }

  }

  protected abstract String word2str(WordRecord r);

  public AMatrix getWPCM() {
    return wpcm;
  }

  public AMatrix getPWM() {
    return pwm;
  }

  public double[] getBackground() {
    return background;
  }

  public void setDiagnosis(String diagnosis) {
    this.diagnosis = diagnosis;
  }

  public String getDiagnosis() {
    return diagnosis;
  }

  private Double pvalue = null;
  public double pvalue() {
    if (pvalue != null) return pvalue;
    pvalue = estimatePvalue();
    return pvalue;
  };

  protected abstract double estimatePvalue();
}
