package ru.autosome.ytilib;

import ru.autosome.perfectosape.backgroundModels.Background;
import ru.autosome.perfectosape.backgroundModels.BackgroundModel;
import ru.autosome.perfectosape.calculations.HashOverflowException;
import ru.autosome.perfectosape.calculations.findPvalue.CanFindPvalue;
import ru.autosome.perfectosape.calculations.findPvalue.FindPvalueAPE;
import ru.autosome.perfectosape.motifModels.PWM;

import java.util.Arrays;

public class PerfectosPvalue {

  private final FindPvalueAPE<PWM, BackgroundModel> calculator;

  public PerfectosPvalue(WPCM pwm, double[] background) {

    BackgroundModel backgroundModel = new Background(Arrays.copyOfRange(background, 0, 4));
    double[][] newMatrix = new double[pwm.length()][4];
    double[][] oldMatrix = pwm.getMatrix();
    for (int i = 0; i < pwm.length(); i++) {
      for (int l = 0; l < 4; l++) {
        newMatrix[i][l] = oldMatrix[l][i];
      }
    }
    calculator = new FindPvalueAPE<PWM, BackgroundModel>(new PWM(newMatrix, null), backgroundModel, 10000.0, null);

  }

  public double PointPvalue(double threshold) {
    CanFindPvalue.PvalueInfo info = null;
    try {
      info = calculator.pvalueByThreshold(threshold);
    } catch (HashOverflowException e) {
      throw new RuntimeException("hash overflow during P-value evaluation");
    }
    return info.pvalue;
  }

}
