package ru.autosome.ytilib;

import org.apache.commons.math3.distribution.BinomialDistribution;
import ru.autosome.assist.AMunkResult;
import ru.autosome.assist.WordRecord;

import java.util.List;

public class MunkResult extends AMunkResult {

  public MunkResult(List<WordRecord> wordList, WPCM pm, double[] background, int seqsUsed, int seqsTotal, double medianSeqLength) {
    super(wordList, pm, background, seqsUsed, seqsTotal, medianSeqLength);
  }

  @Override
  public WPCM getWPCM() {
    return (WPCM)wpcm;
  }

  @Override
  public WPCM getPWM() {
    return (WPCM)pwm;
  }

  @Override
  protected double estimatePvalue() {
    PerfectosPvalue pp = new PerfectosPvalue((WPCM)pwm, background);
    double pv = pp.PointPvalue(threshold);
    double chancePerSeq = 1 - Math.pow((1-pv), medianSeqLength*2);
    BinomialDistribution bd = new BinomialDistribution(seqsTotal, chancePerSeq);
    double p1 = 1 - bd.cumulativeProbability(seqsUsed - 1);
    return p1;
  }

  @Override
  protected String word2str(WordRecord r) {
    return Sequence.seq2str(r.getWord());
  }
}
