package ru.autosome.usage;

import ru.autosome.ChIPAct;
import ru.autosome.ChIPMunk;
import ru.autosome.assist.AShapeProvider;
import ru.autosome.assist.Conductor;
import ru.autosome.ytilib.Sequence;

import java.util.ArrayList;
import java.util.List;

public abstract class ChIPMunkShapeExample {
  public static void main(String[] args) {

    Conductor conductor = new Conductor();
    // conductor.setOutputPrinter(System.out);
    // conductor.setMessagePrinter(System.err);

    List<Sequence[]> sequenceSets = new ArrayList<Sequence[]>();

    // 16 10 yes 1.0 w:Sp1_w1.mfa s:Sp1_s1.mfa

    sequenceSets.add(ChIPAct.loadWeighted("Sp1_w1.mfa", 16));
    sequenceSets.add(ChIPAct.loadSequences("Sp1_s1.mfa", 16));

    ChIPAct.Parameters actParameters = new ChIPAct.Parameters(conductor, sequenceSets);
    ChIPMunk.Parameters munkParameters = new ChIPMunk.Parameters(16, 10, true, 1.0);
    munkParameters.setShapeProvider(AShapeProvider.SingleBox);

    ChIPMunk chipmunk = new ChIPMunk(actParameters, munkParameters);
    chipmunk.launchViaConductor();

   }

}
