package ru.autosome.usage;

import ru.autosome.ChIPAct;
import ru.autosome.ChIPMunk;
import ru.autosome.assist.Conductor;
import ru.autosome.ytilib.Sequence;

import java.util.ArrayList;
import java.util.List;

public abstract class ChIPMunkPeakExample {
  public static void main(String[] args) {

    Conductor conductor = new Conductor();
    // conductor.setOutputPrinter(System.out);
    // conductor.setMessagePrinter(System.err);

    List<Sequence[]> sequenceSets = new ArrayList<Sequence[]>();

    // 16 10 yes 1.0 w:Sp1_w1.mfa s:Sp1_s1.mfa

    sequenceSets.add(ChIPAct.loadPeaks("AP2A_p1.mfa", 16));

    ChIPAct.Parameters actParameters = new ChIPAct.Parameters(conductor, sequenceSets);
    actParameters.setTryLimit(20);

    ChIPMunk.Parameters munkParameters = new ChIPMunk.Parameters(10, 16, true, 1.0);

    ChIPMunk chipmunk = new ChIPMunk(actParameters, munkParameters);
    chipmunk.launchViaConductor();

   }

}
