package ru.autosome.usage;

import ru.autosome.ChIPAct;
import ru.autosome.ChIPApp;
import ru.autosome.ChIPHorde;
import ru.autosome.ChIPMunk;
import ru.autosome.assist.Conductor;
import ru.autosome.ytilib.Sequence;

import java.util.ArrayList;
import java.util.List;

public abstract class ChIPHordeExample {
  public static void main(String[] args) {

    Conductor conductor = Conductor.defaultConductor; // Conductor conductor = new Conductor();

    // conductor.setOutputPrinter(System.out);
    // conductor.setMessagePrinter(System.err);

    List<Sequence[]> sequenceSets = new ArrayList<Sequence[]>();

    // 15:15,10:9 mask yes 1.0 w:Sp1_w1.mfa s:Sp1_s1.mfa

    sequenceSets.add(ChIPAct.loadWeighted("Sp1_w1.mfa", 15));
    sequenceSets.add(ChIPAct.loadSequences("Sp1_s1.mfa", 15));

    ChIPAct.Parameters actParameters = new ChIPAct.Parameters(conductor, sequenceSets);

    ChIPMunk.Parameters munkParameters = new ChIPMunk.Parameters();
    munkParameters.setVerbose(true);
    munkParameters.setZoopsFactor(1.0);

    List<Integer[]> ranges = new ArrayList<Integer[]>();
    ranges.add(new Integer[] {15, 12});
    ranges.add(new Integer[] {10, 9});

    ChIPHorde chiphorde = new ChIPHorde(ranges, ChIPApp.PreprocessMode.MASK, actParameters, munkParameters);
    chiphorde.launchViaConductor();

   }

}
