package ru.autosome.engine;

import ru.autosome.ChIPAct;
import ru.autosome.ytilib.WPCM;

import java.util.concurrent.Callable;

public class Task implements Callable<WPCM> {
  private DoptiStep engine;
  private ChIPAct chipstep;
  private String message = null;

  public Task(DoptiStep engine, ChIPAct chipstep) {
    this.engine = engine;
    this.chipstep = chipstep;
  }

  public void setMessage(String m) {
    this.message = m;
  }

  public WPCM call() throws Exception {

    if (message != null) {
      chipstep.getConductor().tick(message);
    } else {
      chipstep.getConductor().check();
    }
    WPCM pm = engine.launch();
    if (pm != null) chipstep.checkBest(pm);
    return pm;
  }

}
