package ru.autosome.engine;

import ru.autosome.ChIPAct;
import ru.autosome.ytilib.Sequence;
import ru.autosome.ytilib.WPCM;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class DoptiStep {
  private ChIPAct chipstep;
  private int stepLimit;
  private int iterationLimit;

  private Sequence[] sequenceSet;
  private double[] realBackground;
  private double[] defaultBackground;

  protected Random randomizer = new SecureRandom();

  double sampleWeight;
  protected WPCM pm;
  private double[] shape = null;

  public DoptiStep(Sequence[] seqset, double sampleWeight, WPCM seed, ChIPAct chipstep, int stepLimit, int iterationLimit, double[] background, double[] shape) {

    this.sampleWeight = sampleWeight;
    this.sequenceSet = seqset;

    this.realBackground = Sequence.background(sequenceSet);
    this.defaultBackground = background;

    this.pm = seed;
    this.chipstep = chipstep;

    this.stepLimit = stepLimit;
    this.iterationLimit = iterationLimit;

    this.shape = shape;
  }

  public WPCM launch() {

    double currentBestICD = -Double.MAX_VALUE;

    WPCM dores, currentBest = null;

    for (int i = 0; i < stepLimit; i++) {

      SoptiStep step = this.optistep2(iterationLimit);
      dores = step.pm;

      double kdic = dores.kdic(defaultBackground);

      if (kdic > currentBestICD) {
        currentBest = new WPCM(dores);
        currentBestICD = kdic;
      }

      double best = chipstep.getBestInfocod();

      // Current version: replace current local optimum with saved optimum if KDIC difference
      // is larger than KDIC of 1 fully conservative column
      if (best > 0 && kdic + WPCM.KDIC_MAX < best) {
        this.pm = chipstep.getBest();
      }

      // Canonical version:
      //if (best > 0 && kdic < best) {
      //  this.pm = chipstep.getBest();
      //}

    }

    return currentBest;

  }

  protected Sequence[] subSample(double weight) {

    List<Sequence> sample = new ArrayList<Sequence>();

    double cw = 0.0;
    while (cw < weight) {
      Sequence r = sequenceSet[randomizer.nextInt(sequenceSet.length)];
      sample.add(r);
      cw += r.weight;
    }

    return sample.toArray(new Sequence[sample.size()]);

  }

  protected Sequence[] makeSample(int size) {
    Sequence[] largeSub = new Sequence[size];

    for (int r = 0; r < size; r++) {
      largeSub[r] = sequenceSet[randomizer.nextInt(sequenceSet.length)];
    }

    return largeSub;
  }

  public SoptiStep optistep2(int iterationLimit) {

    WPCM step1 = optistep(subSample(sampleWeight), sampleWeight, pm, realBackground, iterationLimit, shape);

    SoptiStep step2 = optistep(sequenceSet, step1, defaultBackground, SoptiStep.GLOBAL_ITERATION_LIMIT, shape);

    pm = new WPCM(step2.pm);
    return step2;
  }

  public static WPCM optistep(Sequence[] sample, double weight, WPCM base, double[] background, int iterationLimit, double[] shape) {
    SoptiStep cp = new SoptiStep(sample, weight, background, iterationLimit, shape);
    cp.optimize(base);
    return cp.pm;
  }

  public static SoptiStep optistep(Sequence[] sample, WPCM base, double[] background, int iterationLimit, double[] shape) {
    if (sample.length == 0) return null;
    SoptiStep cp = new SoptiStep(sample, sample.length, background, iterationLimit, shape);
    cp.optimize(base);
    return cp;
  }


}