package ru.autosome.assist;

public class Helpers {
  public static double[] makeTriangleProfile(int length, int middlepoint) {

    if (middlepoint >= length) throw new RuntimeException("middlepoint " + middlepoint + " out of profile borders (length " + length + ")");

    double[] triangle = new double[length];
    triangle[middlepoint] = 1.0;

    double minHeight = 0.5;

    for (int i = 0; i < middlepoint; i++) {
      // triangle[i] = 0.5 + 0.5*((double)i)/middlepoint;
      triangle[i] = minHeight + (1.0 - minHeight)*((double)i)/middlepoint;
    }
    for (int i = middlepoint+1; i < length; i++) {
      // triangle[i] = 1.0 - (i - middlepoint) / (length - 1.0 - middlepoint) * 0.5;
      triangle[i] = 1.0 - (i - middlepoint) / (length - 1.0 - middlepoint) * (1.0 - minHeight);
    }

    return triangle;
  }
}
