package ru.autosome.assist;

import java.util.List;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class AMatrix {
  protected double[][] matrix;

  public void setN(double n) {
    N = n;
  }
  public double getN() {
    return N;
  }

  protected double N;
  protected int length;

  public double[][] getMatrix() {
    return matrix;
  }

  static final double A0 = 1.0 / 12;
  static final double A1 = 1.0 / 30;
  static final double A2 = 53.0 / 210;
  static final double A3 = 195.0 / 371;
  static final double A4 = 22999.0 / 22737;
  static final double A5 = 29944523.0 / 19733142;
  static final double A6 = 109535241009.0 / 48264275462.0;

  public static double logFact(double f) {
    if (f <= 1) return 0.0;
    double z_big = f + 1;
    return (1.0 / 2) * Math.log(2 * Math.PI) + (z_big - 1.0 / 2) * Math.log(z_big) - z_big + A0 / (z_big + A1 / (z_big + A2 / (z_big + A3 / (z_big + A4 / (z_big + A5 / (z_big + A6 / z_big))))));
  }

  public double score(byte[] seq, double[] profile, int offset) {
    double score = 0;
    for (int i = 0; i < length; i++) {
      // profiled scoring scheme
      score += matrix[seq[offset + i]][i] * profile[offset+i];

    }
    return score;
  }

  public double score(byte[] seq, int seqoffset) {
    double score = 0;
    for (int i = 0; i < length; i++) {
      score += matrix[seq[seqoffset + i]][i];
    }
    return score;
  }

  public double score(byte[] word) {
    double score = 0;
    for (int i = 0; i < word.length; i++) {
      score += matrix[word[i]][i];
    }
    return score;
  }

  /*public double scorevcomp(byte[] seq, int seqoffset, int length) {
    double score = 0;
    for (int i = 0; i < length; i++) {
      score += matrix[Sequence.REVCOMP[seq[seqoffset + length - i - 1]]][i];
    }
    return score;
  }*/

  public double bestScore() {
    double result = 0;
    for (int i = 0; i < length; i++) {
      result += Math.max(matrix[0][i], Math.max(matrix[1][i], Math.max(matrix[2][i], matrix[3][i])));
    }
    return result;
  }

  /*public double scorevcomp(byte[] seq, int offset) {
    double score = 0;
    for (int i = 0; i < length; i++) {
      score += matrix[Sequence.REVCOMP[seq[offset + length - i - 1]]][i];
    }
    return score;
  }*/

  public double bestScore(ASequence sequence, List<Integer> primaryHit, List<Integer> revcompHit) {
    double bestScore = -Double.MAX_VALUE;
    for (Integer i: primaryHit) {
      bestScore = Math.max(this.score(sequence.direct, i), bestScore);
    }
    for (Integer i: revcompHit) {
      bestScore = Math.max(this.score(sequence.revcomp, i), bestScore);
    }
    return bestScore;
  }

  private static final Map<Character, Character> IUPACC = Collections.synchronizedMap(new HashMap<Character, Character>());
  static {
    // "ACGTRYKMSWBDHVN" -> "TGCAYRMKSWVHDBN"
    IUPACC.put('A','T'); IUPACC.put('C','G'); IUPACC.put('G','C'); IUPACC.put('T','A');
    IUPACC.put('R','Y'); IUPACC.put('Y','R'); IUPACC.put('K','M'); IUPACC.put('M','K');
    IUPACC.put('S','S'); IUPACC.put('W','W'); IUPACC.put('B','V'); IUPACC.put('D','H');
    IUPACC.put('H','D'); IUPACC.put('V','B'); IUPACC.put('N','N');
  }
  public static String revcomp(String s) {
    char cs[] = s.toCharArray();
    for (int i = 0; i < cs.length; i++) { cs[i] = IUPACC.get(cs[i]); }

    return new StringBuffer(new String(cs)).reverse().toString();
  }

  public static final Map<String, String> CONSENSUS = Collections.synchronizedMap(new HashMap<String, String>());
  static {
    CONSENSUS.put("A","A"); CONSENSUS.put("C","C"); CONSENSUS.put("G","G"); CONSENSUS.put("T","T");
    CONSENSUS.put("AG","R"); CONSENSUS.put("CT","Y"); CONSENSUS.put("GT","K"); CONSENSUS.put("AC","M");
    CONSENSUS.put("CG","S"); CONSENSUS.put("AT","W");
    CONSENSUS.put("CGT","B"); CONSENSUS.put("AGT","D");
    CONSENSUS.put("ACG","V"); CONSENSUS.put("ACT","H");
    CONSENSUS.put("ACGT","N");
  }

  public double hits(byte[] direct, byte[] revcomp, double[] hdirect, double[] hrevcomp) {

    double ds = hdirect[0] = score(direct, 0);
    double rs = hrevcomp[0] = score(revcomp, 0);

    double best_hit = ds >= rs ? ds : rs;

    for (int i = 1; i <= direct.length - length; i++) {
      hdirect[i] = ds = score(direct, i);
      hrevcomp[i] = rs = score(revcomp, i);
      double hit = ds >= rs ? ds : rs;

      best_hit = best_hit >= hit ? best_hit : hit;
    }

    return best_hit;
  }

  public double hits(byte[] direct, byte[] revcomp, double[] hdirect, double[] hrevcomp, double[] pdirect, double[] prevcomp) {

    double ds = hdirect[0] = score(direct, pdirect, 0);
    double rs = hrevcomp[0] = score(revcomp, prevcomp, 0);

    double best_hit = ds >= rs ? ds : rs;

    for (int i = 1; i <= direct.length - length; i++) {
      hdirect[i] = ds = score(direct, pdirect, i);
      hrevcomp[i] = rs = score(revcomp, prevcomp, i);
      double hit = ds >= rs ? ds : rs;

      best_hit = best_hit >= hit ? best_hit : hit;
    }

    return best_hit;
  }

  public double hits(byte[] direct, double[] hdirect, double[] pdirect) {

    double best_hit = hdirect[0] = score(direct, pdirect, 0);

    for (int i = 1; i <= direct.length - length; i++) {
      hdirect[i] = score(direct, pdirect, i);
      best_hit = best_hit >= hdirect[i] ? best_hit : hdirect[i];
    }

    return best_hit;
  }

  public double m3sd() {
    return scoreMean() + 3 * Math.sqrt(scoreVariance());
  }

  public double scoreMean() {
    double mean = 0.0;
    for (int j = 0; j < length; j++) {
      for (int i = 0; i < 4; i++) // not Sequence.IUPACOUNT, ERROR!
        mean += (matrix[i][j] * 0.25);
    }
    return mean;
  }

  public double scoreVariance() {
    double variance = 0.0;
    for (int j = 0; j < length; j++) {
      double m2 = 0.0;
      double _2m = 0.0;

      for (int i = 0; i < 4; i++) {
        m2 += matrix[i][j]*matrix[i][j]*0.25;
        _2m += matrix[i][j]*0.25;
      }

      variance += m2 - (_2m*_2m);
    }
    return variance;
  }

  public int length() {
    return this.length;
  }

  public double[][] matrix() {
    return matrix;
  }

  public abstract AMatrix makePWM(double[] background);
}
