package ru.autosome.ytilib;

import ru.autosome.assist.AMatrix;

import java.util.List;

public class Peak extends Sequence {

  protected double[] pdirect;
  protected double[] prevcomp;

  public Peak(String sour) {
    super(sour);
    pdirect = new double[this.direct.length];
    prevcomp = new double[this.revcomp.length];
    java.util.Arrays.fill(pdirect, 1.0);
    java.util.Arrays.fill(prevcomp, 1.0);
  }

  public Peak(String sour, double[] pdirect) {
    super(sour);
    this.pdirect = pdirect;
    this.prevcomp = new double[pdirect.length];
    for (int i = 0; i < pdirect.length; i++)
      this.prevcomp[pdirect.length-1-i] = this.pdirect[i];
  }

  public Peak(String newseq, double[] newprof, double weight) {
    this(newseq, newprof);
    this.weight = weight;
  }

  @Override public void bestHits(AMatrix wpcm, List<Integer> prihit, List<Integer> revhit) {
    prihit.clear();
    revhit.clear();

    double best_hit = wpcm.hits(direct, revcomp, hdirect, hrevcomp, pdirect, prevcomp);

    for (int i = 0; i <= direct.length - wpcm.length(); i++) {
      if (hdirect[i] >= best_hit) prihit.add(i);
      if (hrevcomp[i] >= best_hit) revhit.add(i);
    }

  }

  @Override public void rebuild(AMatrix wpcm, List<Integer> prihits, List<Integer> revhits) {
    double total_weight = this.weight / (prihits.size() + revhits.size());

      for (Integer prihit : prihits) {
        for (int j = 0; j < wpcm.length(); j++) {
          wpcm.matrix()[this.direct[prihit + j]][j] += total_weight * pdirect[prihit + j];
          wpcm.matrix()[Sequence.N][j] += total_weight * (1- pdirect[prihit + j]);
        }
      }
      for (Integer revhit : revhits) {
        for (int j = 0; j < wpcm.length(); j++) {
          wpcm.matrix()[this.revcomp[revhit + j]][j] += total_weight * prevcomp[revhit + j];
          wpcm.matrix()[Sequence.N][j] += total_weight * (1- prevcomp[revhit + j]);
        }
      }
  }

  public double top() {
    double top = -Double.MAX_VALUE;
    for (double d : pdirect) {
      top = d > top ? d : top;
    }
    return top;
  }

  public Peak normalize(boolean logWeighting) {
    double peakTop = this.top();
    this.weight = logWeighting ? Math.log(peakTop + 1.0) * this.weight : peakTop * this.weight;
    for (int i = 0; i < this.pdirect.length; i++) {
      this.pdirect[i] /= peakTop;
      this.prevcomp[i] /= peakTop;
    }
    return this;
  }

  public int leftMaximaIndex() {
    double top = top();
    for (int i = 0; i < pdirect.length; i++) {
      if (pdirect[i] == top) return i;
    }
    return -1;
  }

  public int rightMaximaIndex() {
    double top = top();
    for (int i = pdirect.length-1; i >= 0; i--) {
      if (pdirect[i] == top) return i;
    }
    return -1;
  }

  public int localLeftMinimaIndex(int from) {
    int mini = from;
    for (int i = from; i >=0; i--) {
      if (pdirect[i] > pdirect[mini]) return mini;
      mini = i;
    }
    return mini;
  }

  public int localRightMinimaIndex(int from) {
    int maxi = from;
    for (int i = from; i < pdirect.length; i++) {
      if (pdirect[i] > pdirect[maxi]) return maxi;
      maxi = i;
    }
    return maxi;
  }

  public void soften(int length) {
    double[] newpd = new double[this.pdirect.length];
    double[] newpr = new double[this.prevcomp.length];
    for (int i = 0; i < this.pdirect.length; i++) {
      newpd[i] = max(pdirect, i-length + 1, i+length - 1);
      newpr[i] = max(prevcomp, i-length + 1, i+length - 1);
    }
    this.pdirect = newpd;
    this.prevcomp = newpr;
  }

  protected double max(double[] pri, int start, int send) {
    int rs = Math.max(0, start);
    int re = Math.min(send, pri.length-1);
    double max = pri[rs];
    for (int i = rs+1; i <= re; i++) {
      max = max > pri[i] ? max : pri[i];
    }
    return max;
  }

  public Peak(byte[] cdirect, byte[] crevcomp, double weight, double[] cpdirect, double[] cprevcomp) {
    super(cdirect, crevcomp, weight);
    this.pdirect = cpdirect;
    this.prevcomp = cprevcomp;
  }

  @Override public Sequence copy() {

    byte[] cdirect = new byte[this.direct.length];
    byte[] crevcomp = new byte[this.revcomp.length];
    java.lang.System.arraycopy(direct, 0, cdirect, 0, direct.length);
    java.lang.System.arraycopy(revcomp, 0, crevcomp, 0, revcomp.length);

    double[] cpdirect = new double[this.pdirect.length];
    double[] cprevcomp = new double[this.prevcomp.length];
    java.lang.System.arraycopy(pdirect, 0, cpdirect, 0, pdirect.length);
    java.lang.System.arraycopy(prevcomp, 0, cprevcomp, 0, prevcomp.length);

    return new Peak(cdirect, crevcomp, weight, cpdirect, cprevcomp);
  }

}
