package ru.autosome.di.ytilib;

import ru.autosome.assist.ASequence;

public class Sequence extends ASequence {
  
  public Sequence(Sequence sour) {
    weight = sour.weight;
    direct = sour.direct;
    revcomp = sour.revcomp;

    hdirect = new double[this.direct.length];
    hrevcomp = new double[this.revcomp.length];
  }

  public Sequence(String sour) {
    weight = 1.0;
    sour = sour.toUpperCase();
    sour = sour.replaceAll("U","T").replaceAll("[^ACGT]","N");
    direct = new byte[sour.length()-1];
    for (int i = 0; i < sour.length()-1; i++) {
      // fix RNA U-letter (to T) + all unknown to N: ACGTN
      direct[i] = (byte)Din.valueOf(sour.substring(i, i+2)).ordinal();
    }

    revcomp = revcomp();

    hdirect = new double[this.direct.length];
    hrevcomp = new double[this.revcomp.length];
  }

  public Sequence(String sour, double weight) {
    this(sour);
    this.weight = weight;
  }

  public Sequence(Sequence seqc, double weight) {
    this.weight = weight;
    this.direct = seqc.direct;
    this.revcomp = seqc.revcomp;

    hdirect = new double[this.direct.length];
    hrevcomp = new double[this.revcomp.length];
  }

  public Sequence(byte[] cdirect, byte[] crevcomp, double weight) {
    this.weight = weight;
    this.direct = cdirect;
    this.revcomp = crevcomp;

    hdirect = new double[this.direct.length];
    // TODO: beautify RNASequence usage - when no revcomp is present
    hrevcomp = new double[this.revcomp == null ? 0 : this.revcomp.length];
  }

  public byte[] revcomp() {
    byte[] strand2 = new byte[direct.length];
    for (int i = 0; i < direct.length; i++)
      strand2[strand2.length - i - 1] = Din.REVCOMP[direct[i]];
    return strand2;
  }

  public static byte[] str2seq(String s) {
    return new Sequence(s).direct;
  }

  public static String seq2str(byte[] seq) {
    StringBuilder str = new StringBuilder();
    str.append(Din.map.get(seq[0]));
    for (int i = 1; i < seq.length; i++) {
      str.append( Din.map.get(seq[i]).toString().substring(1,2) );
    }
    return str.toString();
  }

  public String word2str(byte[] seq, int offset, int length) {
    StringBuilder str = new StringBuilder();
    str.append(Din.map.get(seq[offset]));
    for (int i = offset + 1; i < offset + length; i++) {
      str.append( Din.map.get(seq[i]).toString().substring(1,2) );
    }
    return str.toString();
  }

  @Override public Sequence copy() {
    byte[] cdirect = new byte[this.direct.length];
    byte[] crevcomp = new byte[this.revcomp.length];
    java.lang.System.arraycopy(direct, 0, cdirect, 0, direct.length);
    java.lang.System.arraycopy(revcomp, 0, crevcomp, 0, revcomp.length);

    return new Sequence(cdirect, crevcomp, weight);
  }

  public static double[] background(Sequence[] sequences) {

    double[] probs = new double[Din.dins];

    int total_length = 0;
    for (Sequence sequence : sequences) {
      total_length += sequence.direct.length;

      for (int i = 0; i < sequence.direct.length; i++) {
        if (sequence.revcomp != null) {
          probs[sequence.direct[i]] += 0.5;
          probs[sequence.revcomp[i]] += 0.5;
        } else { // for RNASequence
          probs[sequence.direct[i]] += 1.0;
        }
      }
    }

    // add N-dins-probs to normal ones
    double NA = probs[(byte)Din.NA.ordinal()] / 4.0;
    probs[(byte)Din.AA.ordinal()] += NA;
    probs[(byte)Din.CA.ordinal()] += NA;
    probs[(byte)Din.GA.ordinal()] += NA;
    probs[(byte)Din.TA.ordinal()] += NA;

    double AN = probs[(byte)Din.AN.ordinal()] / 4.0;
    probs[(byte)Din.AA.ordinal()] += AN;
    probs[(byte)Din.AC.ordinal()] += AN;
    probs[(byte)Din.AG.ordinal()] += AN;
    probs[(byte)Din.AT.ordinal()] += AN;

    double NC = probs[(byte)Din.NC.ordinal()] / 4.0;
    probs[(byte)Din.AC.ordinal()] += NC;
    probs[(byte)Din.CC.ordinal()] += NC;
    probs[(byte)Din.GC.ordinal()] += NC;
    probs[(byte)Din.TC.ordinal()] += NC;

    double CN = probs[(byte)Din.CN.ordinal()] / 4.0;
    probs[(byte)Din.CA.ordinal()] += CN;
    probs[(byte)Din.CC.ordinal()] += CN;
    probs[(byte)Din.CG.ordinal()] += CN;
    probs[(byte)Din.CT.ordinal()] += CN;

    double NG = probs[(byte)Din.NG.ordinal()] / 4.0;
    probs[(byte)Din.AG.ordinal()] += NG;
    probs[(byte)Din.CG.ordinal()] += NG;
    probs[(byte)Din.GG.ordinal()] += NG;
    probs[(byte)Din.TG.ordinal()] += NG;

    double GN = probs[(byte)Din.GN.ordinal()] / 4.0;
    probs[(byte)Din.GA.ordinal()] += GN;
    probs[(byte)Din.GC.ordinal()] += GN;
    probs[(byte)Din.GG.ordinal()] += GN;
    probs[(byte)Din.GT.ordinal()] += GN;

    double NT = probs[(byte)Din.NT.ordinal()] / 4.0;
    probs[(byte)Din.AT.ordinal()] += NT;
    probs[(byte)Din.CT.ordinal()] += NT;
    probs[(byte)Din.GT.ordinal()] += NT;
    probs[(byte)Din.TT.ordinal()] += NT;

    double TN = probs[(byte)Din.TN.ordinal()] / 4.0;
    probs[(byte)Din.TA.ordinal()] += TN;
    probs[(byte)Din.TC.ordinal()] += TN;
    probs[(byte)Din.TG.ordinal()] += TN;
    probs[(byte)Din.TT.ordinal()] += TN;

    double NN = probs[(byte)Din.NN.ordinal()] / 16.0;
    for (byte b = (byte)Din.AA.ordinal(); b <= (byte)Din.TT.ordinal(); b++)
      probs[b] += NN;

    for (int i = 0; i < probs.length; i++) {
      probs[i] /= total_length;
    }

    WPCM.iupacomprobs(probs);

    return probs;
  }

  public static final double[] uniformBackground = new double[Din.dins];
  static {
    for (int i = 0; i < Din.values().length; i++) { uniformBackground[i] = 0.0625; }
  }

}