package ru.autosome.di.ytilib;

import java.util.*;

public class SeedCask {

  private static Random randomizer = new Random();
  private int size;
  private int length;

  public WPCM seed() {
    if (--size < 0) return null;
    WPCM result = cask.poll();
    cask.offer(result);
    return result;
  }

  public WPCM random(int length) {
    double totalWeight = 1.0;
    double[][] matrix = new double[Din.dins][length];
    StringBuilder word = new StringBuilder(length+1);
    char[] letters = new char[] {'A','C','G','T'};
    for (int i = 0; i <= length; i++) {
      word.append(letters[randomizer.nextInt(4)]);
    }
    for (int i = 0; i < length; i++) {
      matrix[Din.valueOf(word.substring(i,i+2)).ordinal()][i] = totalWeight;
    }
    return new WPCM(totalWeight, matrix, true);
  }

  private Queue<WPCM> cask;

  public SeedCask(int size, int pmLength) {
    this.length = pmLength;
    cask = new LinkedList<WPCM>();
    for (int i = 0; i < size; i++) {
      cask.add(random(pmLength));
    }
    this.size = size;
  }

  public int size() {
    return size;
  }

  public int count() {
    return cask.size();
  }

  public void fromPeaks(Peak[] peaks) {
    cask.clear();
    Set<String> temporary = new HashSet<String>();
    for (Peak peak: peaks) {
      int leftBorder = peak.leftMaximaIndex() - length + 1;
      if (leftBorder < 0) leftBorder = 0;
      int rightBorder = peak.rightMaximaIndex();
      if (rightBorder > peak.pdirect.length - length) rightBorder = peak.pdirect.length - length;
      String seq = Peak.seq2str(peak.direct());
      for (int i = leftBorder; i <= rightBorder; i++) {
        temporary.add(seq.substring(i, i+length));
      }
    }
    for (String word: temporary) {
      cask.add(new WPCM(new byte[][]{Peak.str2seq(word)} ));
    }
  }

  public void fromSequences(Sequence[] sequences) {
    cask.clear();
    for (Sequence seq : sequences) {
      for (int i = 0; i <= seq.length() - length; i++) {
        cask.add(new WPCM(length, seq, i));
      }
    }
  }
  
}
