/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.ytilib;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;
import ru.autosome.ytilib.Peak;
import ru.autosome.ytilib.Sequence;
import ru.autosome.ytilib.WPCM;

public class SeedCask {
    private static Random randomizer = new Random();
    private int size;
    private int length;
    private Queue<WPCM> cask;

    public WPCM seed() {
        if (--this.size < 0) {
            return null;
        }
        WPCM result = this.cask.poll();
        this.cask.offer(result);
        return result;
    }

    public WPCM random(int length) {
        double totalWeight = 1.0;
        double[][] matrix = new double[15][length];
        for (int i = 0; i < length; ++i) {
            matrix[SeedCask.randomizer.nextInt((int)4)][i] = totalWeight;
        }
        return new WPCM(matrix, true);
    }

    public SeedCask(int size, int pmLength) {
        this.length = pmLength;
        this.cask = new LinkedList<WPCM>();
        for (int i = 0; i < size; ++i) {
            this.cask.add(this.random(pmLength));
        }
        this.size = size;
    }

    public int size() {
        return this.size;
    }

    public int count() {
        return this.cask.size();
    }

    public void fromPeaks(Peak[] peaks) {
        this.cask.clear();
        HashSet<String> temporary = new HashSet<String>();
        for (Peak peak : peaks) {
            int rightBorder;
            int leftBorder = peak.leftMaximaIndex() - this.length + 1;
            if (leftBorder < 0) {
                leftBorder = 0;
            }
            if ((rightBorder = peak.rightMaximaIndex()) > peak.pdirect.length - this.length) {
                rightBorder = peak.pdirect.length - this.length;
            }
            String seq = Peak.seq2str(peak.direct());
            for (int i = leftBorder; i <= rightBorder; ++i) {
                temporary.add(seq.substring(i, i + this.length));
            }
        }
        for (String word : temporary) {
            this.cask.add(new WPCM(new byte[][]{Peak.str2seq(word)}));
        }
    }

    public void fromSequences(Sequence[] sequences) {
        this.cask.clear();
        for (Sequence seq : sequences) {
            for (int i = 0; i <= seq.length() - this.length; ++i) {
                this.cask.add(new WPCM(this.length, seq, i));
            }
        }
    }
}

