/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.importers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import ru.autosome.perfectosape.importers.BufferedPushbackReader;
import ru.autosome.perfectosape.importers.InputExtensions;

public class PMParser {
    private double[][] matrix;
    private String name;

    public PMParser(List<String> input) {
        this.parse(input);
    }

    public PMParser(double[][] matrix, String name) {
        this.matrix = matrix;
        this.name = name;
    }

    public static PMParser from_file(File input_file) {
        try {
            FileInputStream reader = new FileInputStream(input_file);
            return new PMParser(InputExtensions.readLinesFromInputStream(reader));
        }
        catch (FileNotFoundException err) {
            System.err.println(err.getMessage());
            return null;
        }
    }

    public static PMParser from_file_or_stdin(String filename_or_stdin) {
        try {
            InputStream reader;
            if (filename_or_stdin.equals(".stdin")) {
                reader = System.in;
            } else if (new File(filename_or_stdin).exists()) {
                reader = new FileInputStream(filename_or_stdin);
            } else {
                throw new FileNotFoundException("Error! File " + filename_or_stdin + " doesn't exist");
            }
            return new PMParser(InputExtensions.readLinesFromInputStream(reader));
        }
        catch (FileNotFoundException err) {
            System.err.println(err.getMessage());
            return null;
        }
    }

    public static String parseName(String line) {
        String name = line.trim();
        while (!(name.isEmpty() || name.charAt(0) != '>' && name.charAt(0) != ' ' && name.charAt(0) != '\t')) {
            name = name.substring(1, name.length());
        }
        return name;
    }

    public static double[] parseMatrixLine(String line) {
        StringTokenizer parser = new StringTokenizer(line.replaceAll("\\s+", " "));
        double[] data = new double[parser.countTokens()];
        for (int j = 0; j < data.length; ++j) {
            String elem = parser.nextToken(" ");
            data[j] = Double.valueOf(elem);
        }
        return data;
    }

    private void parse(List<String> inp_strings) {
        ArrayList<double[]> matrix_as_list = new ArrayList<double[]>();
        this.name = "";
        int i = 0;
        if (!InputExtensions.startWithDouble(inp_strings.get(0))) {
            this.name = PMParser.parseName(inp_strings.get(0));
            ++i;
        }
        while (i < inp_strings.size()) {
            matrix_as_list.add(PMParser.parseMatrixLine(inp_strings.get(i)));
            ++i;
        }
        this.matrix = new double[matrix_as_list.size()][];
        for (int j = 0; j < matrix_as_list.size(); ++j) {
            this.matrix[j] = (double[])matrix_as_list.get(j);
        }
    }

    public static PMParser loadFromStream(BufferedPushbackReader reader) {
        ArrayList<double[]> matrix = new ArrayList<double[]>();
        String name = "";
        try {
            while (reader.eatEndOfLine()) {
            }
            String line = reader.readLine();
            if (InputExtensions.startWithDouble(line)) {
                reader.unreadLine(line);
            } else {
                name = PMParser.parseName(line);
            }
            boolean endOfMatrix = false;
            while (!endOfMatrix) {
                String line2 = reader.readLine();
                if (InputExtensions.startWithDouble(line2)) {
                    matrix.add(PMParser.parseMatrixLine(line2));
                    continue;
                }
                reader.unreadLine(line2);
                endOfMatrix = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!matrix.isEmpty()) {
            return new PMParser((double[][])matrix.toArray((T[])new double[matrix.size()][]), name);
        }
        return null;
    }

    public double[][] matrix() {
        return this.matrix;
    }

    public String name() {
        return this.name;
    }
}

