/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.examples;

import ru.autosome.perfectosape.BoundaryType;
import ru.autosome.perfectosape.api.FindThresholdAPE;
import ru.autosome.perfectosape.backgroundModels.BackgroundModel;
import ru.autosome.perfectosape.backgroundModels.WordwiseBackground;
import ru.autosome.perfectosape.calculations.HashOverflowException;
import ru.autosome.perfectosape.calculations.findThreshold.CanFindThreshold;
import ru.autosome.perfectosape.calculations.findThreshold.FindThresholdAPE;
import ru.autosome.perfectosape.importers.PMParser;
import ru.autosome.perfectosape.motifModels.PWM;

public class FindThreshold {
    static void print_result(CanFindThreshold.ThresholdInfo info, BackgroundModel background, int pwmLength) {
        System.out.println("expected pvalue: " + info.expected_pvalue + "\nthreshold: " + info.threshold + "\nactual pvalue: " + info.real_pvalue + "\nnumber of recognized words: " + info.numberOfRecognizedWords(background, pwmLength) + "\n------------\n");
    }

    public static void main(String[] args) {
        PWM pwm = PWM.fromParser(PMParser.from_file_or_stdin("test_data/pwm/KLF4_f2.pwm"));
        WordwiseBackground background = new WordwiseBackground();
        double discretization = 10000.0;
        BoundaryType pvalue_boundary = BoundaryType.LOWER;
        Integer max_hash_size = null;
        double pvalue = 5.0E-4;
        double[] pvalues = new double[]{1.0E-4, 5.0E-4, 0.001};
        FindThresholdAPE<PWM, WordwiseBackground> calculator = new FindThresholdAPE<PWM, WordwiseBackground>(pwm, background, discretization, max_hash_size);
        CanFindThreshold.ThresholdInfo info = null;
        try {
            info = calculator.thresholdByPvalue(pvalue, pvalue_boundary);
        }
        catch (HashOverflowException e) {
            e.printStackTrace();
        }
        FindThreshold.print_result(info, background, pwm.length());
        CanFindThreshold.ThresholdInfo[] infos = new CanFindThreshold.ThresholdInfo[]{};
        try {
            infos = calculator.thresholdsByPvalues(pvalues, pvalue_boundary);
        }
        catch (HashOverflowException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < infos.length; ++i) {
            FindThreshold.print_result(infos[i], background, pwm.length());
        }
        FindThresholdAPE.Parameters parameters = new FindThresholdAPE.Parameters(pwm, pvalues, background, discretization, pvalue_boundary, max_hash_size);
        ru.autosome.perfectosape.api.FindThresholdAPE bioumlCalculator = new ru.autosome.perfectosape.api.FindThresholdAPE(parameters);
        CanFindThreshold.ThresholdInfo[] infosBiouml = (CanFindThreshold.ThresholdInfo[])bioumlCalculator.call();
        for (int i = 0; i < infosBiouml.length; ++i) {
            FindThreshold.print_result(infosBiouml[i], background, pwm.length());
        }
    }
}

