/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.cli;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.autosome.perfectosape.BoundaryType;
import ru.autosome.perfectosape.backgroundModels.Background;
import ru.autosome.perfectosape.backgroundModels.BackgroundModel;
import ru.autosome.perfectosape.backgroundModels.WordwiseBackground;
import ru.autosome.perfectosape.calculations.ScanCollection;
import ru.autosome.perfectosape.calculations.findPvalue.FindPvalueAPE;
import ru.autosome.perfectosape.calculations.findPvalue.FindPvalueBsearchBuilder;
import ru.autosome.perfectosape.calculations.findThreshold.FindThresholdAPE;
import ru.autosome.perfectosape.calculations.findThreshold.FindThresholdBsearchBuilder;
import ru.autosome.perfectosape.cli.Helper;
import ru.autosome.perfectosape.formatters.OutputInformation;
import ru.autosome.perfectosape.formatters.ResultInfo;
import ru.autosome.perfectosape.importers.MotifCollectionImporter;
import ru.autosome.perfectosape.importers.PMParser;
import ru.autosome.perfectosape.importers.PWMImporter;
import ru.autosome.perfectosape.motifModels.DataModel;
import ru.autosome.perfectosape.motifModels.PWM;

public class ScanCollection {
    private static final String DOC = "Command-line format:\njava ru.autosome.perfectosape.cli.ScanCollection <query PWM file> <folder with PWMs> [options]\n\nOptions:\n  [-p <P-value>]\n  [-c <similarity cutoff>] minimal similarity to be included in output, '-c 0.05' by default, [--all] to print all results\n  [--precise [<level>]] minimal similarity to check on the second pass in precise mode, off by default, '--precise 0.01' if level is not set\n  [--rough-discretization <discretization level>] or [-d]\n  [--precise-discretization <discretization level>]\n  [--silent] - hide current progress information during scan (printed to stderr by default)\n  [--pcm] - treat the query input file as Position Count Matrix. PCM-to-PWM transformation to be done internally.\n  [--ppm] or [--pfm] - treat the query input file as Position Frequency Matrix. PPM-to-PWM transformation to be done internally.\n  [--effective-count <count>] - effective samples set size for PPM-to-PWM conversion (default: 100). \n  [--boundary lower|upper] Upper boundary (default) means that the obtained P-value is greater than or equal to the requested P-value\n  [-b <background probabilities] ACGT - 4 numbers, comma-delimited(spaces not allowed), sum should be equal to 1, like 0.25,0.24,0.26,0.25\n  [--precalc <folder>] - specify folder with thresholds for PWM collection (for fast-and-rough calculation).\n\nOutput format:\n           <name> <jaccard index> <shift> <overlap> <orientation> ['*' in case that result was calculated on the second pass (in precise mode), '.' otherwise]\n              Attention! Name can contain whitespace characters.\n              Attention! The shift and orientation are reported for the collection matrix relative to the query matrix.\n\nExamples:\n  java ru.autosome.perfectosape.cli.ScanCollection ./query_motif.pwm ./hocomoco/ --precalc ./hocomoco_thresholds\n  java ru.autosome.perfectosape.cli.ScanCollection ./query_motif.pcm ./hocomoco/ --pcm -p 0.0005 --precise 0.03\n";
    DataModel dataModel;
    Double effectiveCount;
    BackgroundModel queryBackground;
    BackgroundModel collectionBackground;
    Double roughDiscretization;
    Double preciseDiscretization;
    Integer maxHashSize;
    Integer maxPairHashSize;
    double pvalue;
    Double queryPredefinedThreshold;
    Double similarityCutoff;
    Double preciseRecalculationCutoff;
    BoundaryType pvalueBoundaryType;
    boolean silenceLog;
    String queryPMFilename;
    File pathToCollectionOfPWMs;
    File thresholds_folder;
    PWM queryPWM;
    List<ScanCollection.ThresholdEvaluator> pwmCollection;

    private void initialize_defaults() {
        this.queryBackground = new WordwiseBackground();
        this.collectionBackground = new WordwiseBackground();
        this.roughDiscretization = 1.0;
        this.preciseDiscretization = 10.0;
        this.maxHashSize = 10000000;
        this.maxPairHashSize = 10000;
        this.dataModel = DataModel.PWM;
        this.effectiveCount = 100.0;
        this.thresholds_folder = null;
        this.silenceLog = false;
        this.pvalueBoundaryType = BoundaryType.UPPER;
        this.pvalue = 5.0E-4;
        this.similarityCutoff = 0.05;
        this.preciseRecalculationCutoff = null;
    }

    private ScanCollection() {
        this.initialize_defaults();
    }

    private static ScanCollection from_arglist(ArrayList<String> argv) throws FileNotFoundException {
        ScanCollection result = new ScanCollection();
        Helper.print_help_if_requested(argv, DOC);
        result.setup_from_arglist(argv);
        return result;
    }

    private static ScanCollection from_arglist(String[] args) throws FileNotFoundException {
        ArrayList<String> argv = new ArrayList<String>();
        Collections.addAll(argv, args);
        return ScanCollection.from_arglist(argv);
    }

    private void extract_query_pm_filename(ArrayList<String> argv) {
        if (argv.isEmpty()) {
            throw new IllegalArgumentException("No input. You should specify input file");
        }
        this.queryPMFilename = argv.remove(0);
    }

    void extract_path_to_collection_of_pwms(ArrayList<String> argv) {
        try {
            this.pathToCollectionOfPWMs = new File(argv.remove(0));
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Specify PWM-collection folder", e);
        }
    }

    private List<ScanCollection.ThresholdEvaluator> load_collection_of_pwms() throws FileNotFoundException {
        PWMImporter pwmImporter = new PWMImporter(this.collectionBackground, this.dataModel, this.effectiveCount);
        MotifCollectionImporter<PWM> collectionImporter = new MotifCollectionImporter<PWM>(pwmImporter);
        List<PWM> pwmList = collectionImporter.loadPWMCollection(this.pathToCollectionOfPWMs);
        ArrayList<ScanCollection.ThresholdEvaluator> result = new ArrayList<ScanCollection.ThresholdEvaluator>();
        for (PWM pwm : pwmList) {
            if (this.thresholds_folder == null) {
                result.add(new ScanCollection.ThresholdEvaluator(pwm, new FindThresholdAPE<PWM, BackgroundModel>(pwm, this.collectionBackground, this.roughDiscretization, this.maxHashSize), new FindThresholdAPE<PWM, BackgroundModel>(pwm, this.collectionBackground, this.preciseDiscretization, this.maxHashSize), new FindPvalueAPE<PWM, BackgroundModel>(pwm, this.collectionBackground, this.roughDiscretization, this.maxHashSize), new FindPvalueAPE<PWM, BackgroundModel>(pwm, this.collectionBackground, this.preciseDiscretization, this.maxHashSize)));
                continue;
            }
            result.add(new ScanCollection.ThresholdEvaluator(pwm, new FindThresholdBsearchBuilder(this.thresholds_folder).thresholdCalculator(pwm), null, new FindPvalueBsearchBuilder(this.thresholds_folder).pvalueCalculator(pwm), null));
        }
        return result;
    }

    void setup_from_arglist(ArrayList<String> argv) throws FileNotFoundException {
        this.extract_query_pm_filename(argv);
        this.extract_path_to_collection_of_pwms(argv);
        while (argv.size() > 0) {
            this.extract_option(argv);
        }
        this.queryPWM = (PWM)new PWMImporter(this.queryBackground, this.dataModel, this.effectiveCount).loadPWMFromParser(PMParser.from_file_or_stdin(this.queryPMFilename));
        this.pwmCollection = this.load_collection_of_pwms();
    }

    private void extract_option(ArrayList<String> argv) {
        String opt = argv.remove(0);
        if (opt.equals("-b")) {
            BackgroundModel background;
            this.queryBackground = background = Background.fromString(argv.remove(0));
            this.collectionBackground = background;
        } else if (opt.equals("--query-background")) {
            this.queryBackground = Background.fromString(argv.remove(0));
        } else if (opt.equals("--collection-background")) {
            this.collectionBackground = Background.fromString(argv.remove(0));
        } else if (opt.equals("--max-hash-size")) {
            this.maxHashSize = Integer.valueOf(argv.remove(0));
        } else if (opt.equals("--max-2d-hash-size")) {
            this.maxPairHashSize = Integer.valueOf(argv.remove(0));
        } else if (opt.equals("--rough-discretization") || opt.equals("-d")) {
            this.roughDiscretization = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--precise-discretization")) {
            this.preciseDiscretization = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--boundary")) {
            this.pvalueBoundaryType = BoundaryType.valueOf(argv.remove(0).toUpperCase());
        } else if (opt.equals("--pcm")) {
            this.dataModel = DataModel.PCM;
        } else if (opt.equals("--ppm") || opt.equals("--pfm")) {
            this.dataModel = DataModel.PPM;
        } else if (opt.equals("--effective-count")) {
            this.effectiveCount = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--precalc")) {
            this.thresholds_folder = new File(argv.remove(0));
        } else if (opt.equals("-p")) {
            this.pvalue = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--predefined-threshold")) {
            this.queryPredefinedThreshold = Double.valueOf(argv.remove(0));
        } else if (opt.equals("-c")) {
            this.similarityCutoff = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--all")) {
            this.similarityCutoff = 0.0;
        } else if (opt.equals("--precise")) {
            this.preciseRecalculationCutoff = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--silent")) {
            this.silenceLog = true;
        } else {
            throw new IllegalArgumentException("Unknown option '" + opt + "'");
        }
    }

    public OutputInformation report_table_layout() {
        OutputInformation infos = new OutputInformation();
        infos.add_parameter("MS", "minimal similarity to output", this.similarityCutoff);
        infos.add_parameter("P", "P-value", this.pvalue);
        infos.add_parameter("PB", "P-value boundary", (Object)this.pvalueBoundaryType);
        if (this.preciseRecalculationCutoff != null) {
            infos.add_parameter("VR", "discretization value, rough", this.roughDiscretization);
            infos.add_parameter("VP", "discretization value, precise", this.preciseDiscretization);
            infos.add_parameter("MP", "minimal similarity for the 2nd pass in 'precise' mode", this.preciseRecalculationCutoff);
        } else {
            infos.add_parameter("V", "discretization value", this.roughDiscretization);
        }
        infos.background_parameter("BQ", "background for query matrix", this.queryBackground);
        infos.background_parameter("BC", "background for collection", this.collectionBackground);
        infos.add_table_parameter_without_description("motif", "name");
        infos.add_table_parameter_without_description("similarity", "similarity");
        infos.add_table_parameter_without_description("shift", "shift");
        infos.add_table_parameter_without_description("overlap", "overlap");
        infos.add_table_parameter_without_description("orientation", "orientation");
        if (this.preciseRecalculationCutoff != null) {
            infos.add_table_parameter_without_description("precise mode", "precision_mode", new OutputInformation.Callback<ScanCollection.SimilarityInfo>(){

                public String run(ScanCollection.SimilarityInfo cell) {
                    return cell.precise ? "*" : ".";
                }
            });
        }
        return infos;
    }

    private ru.autosome.perfectosape.calculations.ScanCollection calculator() {
        ru.autosome.perfectosape.calculations.ScanCollection calculator = new ru.autosome.perfectosape.calculations.ScanCollection(this.pwmCollection, this.queryPWM);
        calculator.pvalue = this.pvalue;
        calculator.queryPredefinedThreshold = this.queryPredefinedThreshold;
        calculator.roughDiscretization = this.roughDiscretization;
        calculator.preciseDiscretization = this.preciseDiscretization;
        calculator.queryBackground = this.queryBackground;
        calculator.collectionBackground = this.collectionBackground;
        calculator.pvalueBoundaryType = this.pvalueBoundaryType;
        calculator.maxHashSize = this.maxHashSize;
        calculator.maxPairHashSize = this.maxPairHashSize;
        calculator.similarityCutoff = this.similarityCutoff;
        calculator.preciseRecalculationCutoff = this.preciseRecalculationCutoff;
        return calculator;
    }

    OutputInformation report_table(List<? extends ResultInfo> data) {
        OutputInformation result = this.report_table_layout();
        result.data = data;
        return result;
    }

    <R extends ResultInfo> OutputInformation report_table(R[] data) {
        ArrayList data_list = new ArrayList(data.length);
        Collections.addAll(data_list, data);
        return this.report_table(data_list);
    }

    List<? extends ResultInfo> process() throws Exception {
        List<ScanCollection.SimilarityInfo> infos = this.calculator().similarityInfos();
        return infos;
    }

    public static void main(String[] args) {
        try {
            ScanCollection calculation = ScanCollection.from_arglist(args);
            List<? extends ResultInfo> infos = calculation.process();
            System.out.println(calculation.report_table(infos).report());
        }
        catch (Exception err) {
            System.err.println("\n" + err.getMessage() + "\n--------------------------------------\n");
            err.printStackTrace();
            System.err.println("\n--------------------------------------\nUse --help option for help\n\nCommand-line format:\njava ru.autosome.perfectosape.cli.ScanCollection <query PWM file> <folder with PWMs> [options]\n\nOptions:\n  [-p <P-value>]\n  [-c <similarity cutoff>] minimal similarity to be included in output, '-c 0.05' by default, [--all] to print all results\n  [--precise [<level>]] minimal similarity to check on the second pass in precise mode, off by default, '--precise 0.01' if level is not set\n  [--rough-discretization <discretization level>] or [-d]\n  [--precise-discretization <discretization level>]\n  [--silent] - hide current progress information during scan (printed to stderr by default)\n  [--pcm] - treat the query input file as Position Count Matrix. PCM-to-PWM transformation to be done internally.\n  [--ppm] or [--pfm] - treat the query input file as Position Frequency Matrix. PPM-to-PWM transformation to be done internally.\n  [--effective-count <count>] - effective samples set size for PPM-to-PWM conversion (default: 100). \n  [--boundary lower|upper] Upper boundary (default) means that the obtained P-value is greater than or equal to the requested P-value\n  [-b <background probabilities] ACGT - 4 numbers, comma-delimited(spaces not allowed), sum should be equal to 1, like 0.25,0.24,0.26,0.25\n  [--precalc <folder>] - specify folder with thresholds for PWM collection (for fast-and-rough calculation).\n\nOutput format:\n           <name> <jaccard index> <shift> <overlap> <orientation> ['*' in case that result was calculated on the second pass (in precise mode), '.' otherwise]\n              Attention! Name can contain whitespace characters.\n              Attention! The shift and orientation are reported for the collection matrix relative to the query matrix.\n\nExamples:\n  java ru.autosome.perfectosape.cli.ScanCollection ./query_motif.pwm ./hocomoco/ --precalc ./hocomoco_thresholds\n  java ru.autosome.perfectosape.cli.ScanCollection ./query_motif.pcm ./hocomoco/ --pcm -p 0.0005 --precise 0.03\n");
            System.exit(1);
        }
    }
}

