/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.calculations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import ru.autosome.perfectosape.Position;
import ru.autosome.perfectosape.Sequence;
import ru.autosome.perfectosape.motifModels.ScoringModel;

public class ScanSequence {
    private final Sequence sequence;
    private final ScoringModel pwm;
    ArrayList<Position> positions_to_check;
    private Map<Position, Double> cache_score_by_position;

    public ScanSequence(Sequence sequence, ScoringModel pwm, ArrayList<Position> positions_to_check) {
        this.sequence = sequence;
        this.pwm = pwm;
        this.positions_to_check = positions_to_check;
    }

    public ScanSequence(Sequence sequence, ScoringModel pwm) {
        this(sequence, pwm, sequence.subsequence_positions(pwm.length()));
    }

    Map<Position, Double> scores_by_position() {
        if (this.cache_score_by_position == null) {
            this.cache_score_by_position = new HashMap<Position, Double>();
            for (Position position : this.positions_to_check) {
                Sequence subsequence = this.sequence.substring(position, this.pwm.length());
                this.cache_score_by_position.put(position, this.pwm.score(subsequence));
            }
        }
        return this.cache_score_by_position;
    }

    public Position best_position() {
        Double max_score = Double.NEGATIVE_INFINITY;
        Position best_position = null;
        for (Position position : this.scores_by_position().keySet()) {
            if (!(this.scores_by_position().get(position) > max_score)) continue;
            best_position = position;
            max_score = this.scores_by_position().get(position);
        }
        return best_position;
    }

    public double best_score() {
        return this.scores_by_position().get(this.best_position());
    }
}

